/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

/**
 * A WAS cell is an administrative domain that holds the configuration for one or more WAS server, clusters, etc.
 */
public interface Cell extends WasContainer, PythonManagingContainer {

	/**
	 * Returns the name of the cell.
	 * 
	 * @return the name
	 */
	@DerivedProperty("cellName")
	String getCellName();

	/**
	 * Returns the version of WAS.
	 * 
	 * @return the version.
	 */
	WasVersion getVersion();

	/**
	 * Sets the version of WAS.
	 * 
	 * @param version
	 *            the version.
	 */
	void setVersion(WasVersion version);

	/**
	 * Returns the profile directory of WAS on the administrative host.
	 * 
	 * @return the profile directory
	 */
	String getWasHome();

	/**
	 * Returns the administrative port.
	 * 
	 * @return the port
	 */
	int getPort();

	/**
	 * Returns the host the cell is administered on.
	 * 
	 * @return the host
	 */
	Host getCellHost();

	/**
	 * Returns the username which is used to login to the WebSphere deployment manager
	 * 
	 * @return the username
	 */
	String getUsername();

	/**
	 * Returns the password which is used to login to the WebSphere deployment manager
	 * 
	 * @return the password
	 */
	String getPassword();

	/**
	 * Returns the path of the "config" directory in the WAS installation.
	 * 
	 * @return the path of the "config" directory
	 */
	String getConfigDirPath();

	/**
	 * Returns the path to the plugin config file in the WAS installation.
	 * 
	 * @return the path to the plugin config file
	 */
	String getPluginFilePath();

	/**
	 * Returns the path to the versionInfo command in the WAS installation.
	 * 
	 * @return the path to the versionInfo command
	 */
	String getVersionInfoPath();

	/**
	 * Returns the path to the wsadmin command in the WAS installation.
	 * 
	 * @return the path to the wsadmin command
	 */
	String getWsadminPath();

	/**
	 * Returns the path to the startServer command in the WAS installation.
	 * 
	 * @return the path to the startServer command
	 */
	String getStartServerPath();

	/**
	 * Returns the path to the stopServer command in the WAS installation.
	 * 
	 * @return the path to the stopServer command
	 */
	String getStopServerPath();

	/**
	 * Returns the path to the serverStatus command in the WAS installation.
	 * 
	 * @return the path to the serverStatus command
	 */
	String getServerStatusPath();

}
