#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

datasourceContainmentPath = '%s/JDBCProvider:%s/DataSource:%s/' % (deployed.container.containmentPath, deployed.jdbcProvider, deployed.name)

datasourceId = AdminConfig.getid(datasourceContainmentPath)
if datasourceId == "":
    print "Datasource %s does not exist in containment path %s" % (deployed.name, datasourceContainmentPath)
    sys.exit(1);

inspected('jndiName', AdminConfig.showAttribute(datasourceId, 'jndiName'))
inspected('datasourceHelperClassname', AdminConfig.showAttribute(datasourceId, 'datasourceHelperClassname'))
inspected('jdbcProvider', AdminConfig.showAttribute(AdminConfig.showAttribute(datasourceId, 'provider'), 'name'))

propertySet = AdminConfig.showAttribute(datasourceId, 'propertySet')
resourceProperties = AdminConfig.showAttribute(propertySet, 'resourceProperties')[1:-1].split()
for resourceProperty in resourceProperties:
    name = AdminConfig.showAttribute(resourceProperty, 'name')
    if name != 'name':
        value = AdminConfig.showAttribute(resourceProperty, 'value')
        inspected(name, value)

jaasName = AdminConfig.showAttribute(datasourceId, 'authDataAlias')
authdataIds = AdminConfig.list('JAASAuthData').split();
for authdataId in authdataIds:
    if AdminConfig.showAttribute(authdataId, 'alias') == jaasName:
        inspected('username', AdminConfig.showAttribute(authdataId, 'userId'))

connectionPool = AdminConfig.showAttribute(datasourceId, 'connectionPool')
inspected('ConnectionPool_connectionTimeout', AdminConfig.showAttribute(connectionPool, "connectionTimeout"))
inspected('ConnectionPool_maxConnections', AdminConfig.showAttribute(connectionPool, "maxConnections"))
inspected('ConnectionPool_minConnections', AdminConfig.showAttribute(connectionPool, "minConnections"))
