/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.util.WasVersionInfoParser;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;

public class GetWasVersionStep
implements InspectionStep {
    private Cell cell;

    public GetWasVersionStep(Cell cell) {
        this.cell = cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(InspectionExecutionContext ctx) throws Exception {
        OverthereConnection adminConnection = this.cell.getHost().getConnection();
        try {
            CapturingOverthereProcessOutputHandler capturedOutput = CapturingOverthereProcessOutputHandler.capturingHandler();
            int res = adminConnection.execute((OverthereProcessOutputHandler)capturedOutput, CmdLine.build((String[])new String[]{this.cell.getVersionInfoPath()}));
            if (res != 0) {
                ctx.logError("Non-zero exitcode from " + this.cell.getVersionInfoPath() + ": " + res);
                Step.Result result = Step.Result.Fail;
                return result;
            }
            Step.Result result = this.checkWasVersion(ctx, capturedOutput);
            return result;
        }
        finally {
            adminConnection.close();
        }
    }

    private Step.Result checkWasVersion(InspectionExecutionContext ctx, CapturingOverthereProcessOutputHandler capturedOutput) {
        WasVersionInfoParser wasVersionInfoParser = new WasVersionInfoParser().parse(capturedOutput.getOutputLines());
        if (wasVersionInfoParser.isSuccess()) {
            if (wasVersionInfoParser.majorVersion == 6 && wasVersionInfoParser.minorVersion == 1) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_61);
            } else if (wasVersionInfoParser.majorVersion == 7 && wasVersionInfoParser.minorVersion == 0) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_70);
            } else if (wasVersionInfoParser.majorVersion == 8 && wasVersionInfoParser.minorVersion == 0) {
                ((BaseCell)this.cell).setVersion(WasVersion.WAS_80);
            } else {
                ctx.logError("Cannot set version on " + this.cell + ": version " + wasVersionInfoParser.majorVersion + "." + wasVersionInfoParser.minorVersion + " is not supported");
                return Step.Result.Fail;
            }
            return Step.Result.Success;
        }
        ctx.logError("Could not determine installed version of " + this.cell);
        return Step.Result.Fail;
    }

    public String getDescription() {
        return "Get version of " + this.cell;
    }
}

