/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

@SuppressWarnings("serial")
@Metadata(description = "A WebSphere server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedServer extends BaseContainer implements Server, WasAppContainer {

	@Property(asContainment = true, label = "WebSphere node", description = "Node on which the server runs")
	private NodeAgent node;
	
	@Property(required = true, defaultValue = "was/server/restart-server.py", hidden = true)
	private String restartServerScript;

	public NodeAgent getNode() {
		return node;
	}

	public void setNode(NodeAgent node) {
		this.node = node;
	}

	@Override
	public Cell getCell() {
		return this.getNode().getCell();
	}

	@Override
	public PythonManagingContainer getManagingContainer() {
		return getCell();
	}

	@Override
	public String getCellName() {
		return getCell().getName();
	}

	@DerivedProperty("nodeName")
	public String getNodeName() {
		return getNode().getName();
	}

	@Override
	public Set<Node> getNodes() {
		return Collections.singleton((Node) this.getNode());
	}

	@Override
    public String getContainmentPath() {
	    return "/Node:" + getNodeName() + "/Server:" + getName();
    }


	@Override
	public String getWasConfigIdType() {
		return "Server";
	}

	@Override
	public String getWasTargetType() {
		return "server";
	}

	@Override
	public String getShortTypeDescription() {
		return "managed server";
	}

	public List<String> getApplicationManagerObjectNames() {
		String appMgrObjectName = "cell=" + getCell().getCellName() + ",node=" + getNode().getName() + ",type=ApplicationManager,process=" + getName() + ",*";
		return Collections.singletonList(appMgrObjectName);
	}

	@Override
    public String getServerRestartScript() {
	    return restartServerScript;
    }

}
