package com.xebialabs.deployit.plugin.was.deployed;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifacts;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.PlaceholderReplacer;
import com.xebialabs.overthere.OverthereFile;

@SuppressWarnings("serial")
@Metadata(virtual = true, description="Base class for all extensible deployed artifact configuration items.")
public class ExtensibleDeployedArtifact extends ExtensibleDeployed<DeployableArtifact> implements DerivedArtifact<DeployableArtifact> {

	private OverthereFile derivedFile;

	@Property(description = "A Map containing all the placeholders mapped to their values. Special values are <ignore> or <empty>", required = false)
	private Map<String, String> placeholders = newHashMap();

	@Override
    public OverthereFile getFile() {
	    return derivedFile;
    }

	@Override
    public void setFile(OverthereFile file) {
	    this.derivedFile = file;
    }

	@Override
    public DeployableArtifact getSourceArtifact() {
	    return getDeployable();
    }

	@Override
    public Map<String, String> getPlaceholders() {
	    return placeholders;
    }

	@Override
    public void setPlaceholders(Map<String, String> placeholders) {
		this.placeholders = placeholders;
    }

	@Override
    public void initFile(PlaceholderReplacer replacer) {
		Artifacts.replacePlaceholders(this, replacer);
    }

}
