package com.xebialabs.deployit.plugin.was.container;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;

public class NodeSynchronizer {

	@Contributor
	public void syncNodes(Deltas deltas, DeploymentPlanningContext ctx) {
		Multimap<Integer, NodeAgent> nodesToSync = getNodesToSync(ctx);
		for (int order : nodesToSync.keySet()) {
			for (NodeAgent node : nodesToSync.get(order)) {
				Map<String, Object> pythonVars = newHashMap();
				pythonVars.put("nodeName", node.getNodeName());
				ctx.addStep(new PythonDeploymentStep(order, node.getCell(), node.getSynchronizeScript(), pythonVars, "Synchronize " + node.getName()));
			}
		}
		nodesToSync.clear();
	}

	private static Multimap<Integer, NodeAgent> getNodesToSync(DeploymentPlanningContext ctx) {
		@SuppressWarnings("unchecked")
        Multimap<Integer, NodeAgent> nodesToSync = (Multimap<Integer, NodeAgent>) ctx.getAttribute("was.nodesToSync");
		if(nodesToSync == null) {
			nodesToSync = HashMultimap.create();
			ctx.setAttribute("was.nodesToSync", nodesToSync);
		}
		return nodesToSync;
	}

	public static void addNodeToSync(DeploymentPlanningContext ctx, int order, NodeAgent n) {
		getNodesToSync(ctx).put(order, n);
    }

}
