/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Server;
import com.xebialabs.deployit.plugin.was.container.WasAppContainer;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@Metadata(description="A WebSphere server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedServer
extends BaseContainer
implements Server,
WasAppContainer {
    @Property(asContainment=true, label="WebSphere node", description="Node on which the server runs")
    private NodeAgent node;
    @Property(required=true, defaultValue="was/server/restart-server.py", hidden=true)
    private String restartServerScript;

    public NodeAgent getNode() {
        return this.node;
    }

    public void setNode(NodeAgent nodeAgent) {
        this.node = nodeAgent;
    }

    @Override
    public Cell getCell() {
        return this.getNode().getCell();
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        return this.getCell().getName();
    }

    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        return this.getNode().getName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this.getNode());
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getNodeName() + "/Server:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed server";
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        String string = "cell=" + this.getCell().getCellName() + ",node=" + this.getNode().getName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(string);
    }

    @Override
    public String getServerRestartScript() {
        return this.restartServerScript;
    }
}

