/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;

public class CheckWasInstallationStep
implements InspectionStep {
    private Cell cell;
    private boolean validInstallation;

    public CheckWasInstallationStep(Cell cell) {
        this.cell = cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Step.Result execute(InspectionExecutionContext inspectionExecutionContext) throws Exception {
        OverthereConnection overthereConnection = this.cell.getHost().getConnection();
        try {
            this.validInstallation = true;
            this.checkDirectoryExistence(inspectionExecutionContext, overthereConnection, this.cell.getWasHome());
            this.checkDirectoryExistence(inspectionExecutionContext, overthereConnection, this.cell.getConfigDirPath());
            this.checkFileExistenceAndExecutability(inspectionExecutionContext, overthereConnection, this.cell.getVersionInfoPath());
            this.checkFileExistenceAndExecutability(inspectionExecutionContext, overthereConnection, this.cell.getWsadminPath());
            Step.Result result = this.validInstallation ? Step.Result.Success : Step.Result.Fail;
            return result;
        }
        finally {
            overthereConnection.close();
        }
    }

    protected void checkDirectoryExistence(InspectionExecutionContext inspectionExecutionContext, OverthereConnection overthereConnection, String string) {
        inspectionExecutionContext.logOutput("Checking whether directory " + string + " exists on " + this.cell.getHost());
        if (!overthereConnection.getFile(string).exists()) {
            inspectionExecutionContext.logError("Directory " + string + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        }
    }

    private void checkFileExistenceAndExecutability(InspectionExecutionContext inspectionExecutionContext, OverthereConnection overthereConnection, String string) {
        inspectionExecutionContext.logOutput("Checking whether file " + string + " exists on " + this.cell.getHost() + " exists" + (overthereConnection.getHostOperatingSystem() == OperatingSystemFamily.UNIX ? " and is executable" : ""));
        if (!overthereConnection.getFile(string).exists()) {
            inspectionExecutionContext.logError("File " + string + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        } else if (overthereConnection.getHostOperatingSystem() == OperatingSystemFamily.UNIX && !overthereConnection.getFile(string).canExecute()) {
            inspectionExecutionContext.logError("File " + string + " on " + this.cell.getHost() + " is not executable");
            this.validInstallation = false;
        }
    }

    public String getDescription() {
        return "Checking whether " + this.cell + " is a valid WebSphere Application Server installation";
    }
}

