/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.DelegatedInspectionHelper;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.step.CheckWasInstallationStep;
import com.xebialabs.deployit.plugin.was.step.DiscoveryWasTopologyStep;
import com.xebialabs.deployit.plugin.was.step.GetWasVersionStep;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import java.util.List;
import java.util.Map;

@Metadata(description="Base class for a Webshpere Cell", inspectable=true)
public abstract class BaseCell
extends BaseContainer
implements Cell {
    @Property(required=true, asContainment=true, description="Host on which the unmanaged WAS server runs")
    @InspectionProperty(required=true)
    private Host host;
    @Property(required=true, label="WebSphere Installation Path", description="Root path of the WebSphere installation path. e.g. /opt/ws/6.1/appserver/profiles/AppSrv01", size=Property.Size.MEDIUM)
    @InspectionProperty(required=true)
    private String wasHome;
    @Property(required=false, label="Administrative port", description="TCP port which is used to login to the WebSphere Administration, default is 8880")
    @InspectionProperty(required=false)
    private int port;
    @Property(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Administration.")
    @InspectionProperty(required=false)
    private String username;
    @Property(required=false, password=true, label="Administrative password", description="Password which is used to login to the WebSphere Administration.")
    @InspectionProperty(required=false)
    private String password;
    @Property(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;
    @Property(required=false, label="Run with daemon", description="Set to true to execute commands with the Python daemon", defaultValue="true", hidden=true)
    private boolean runWithDaemon;
    @Property(required=false, hidden=true, defaultValue="was/container/discover-inspect-topology-lib.py", description="List of scripts to appended to runtime script")
    private List<String> libraryScripts = Lists.newArrayList();
    @Property(hidden=true, defaultValue="was/container/discover-inspect-topology.py", description="Inspect script for Cell")
    private String inspectScript;
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";
    public boolean skipTopologyDiscovery;
    public boolean performOnlyTopologyDiscovery;
    public List<Type> deployedTypesToDiscover;

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    @Override
    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String string) {
        this.wasHome = string;
    }

    @Override
    public WasVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(WasVersion wasVersion) {
        this.version = wasVersion;
    }

    @Override
    public Cell getCell() {
        return this;
    }

    @Override
    public Host getCellHost() {
        return this.host;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getConfigDirPath() {
        String string = this.getCellHost().getOs().getFileSeparator();
        return this.getWasHome() + string + CONFIG_DIR_NAME;
    }

    @Override
    public String getPluginFilePath() {
        String string = this.getCellHost().getOs().getFileSeparator();
        return this.getConfigDirPath() + string + "cells" + string + PLUGIN_FILENAME;
    }

    @Override
    public String getWsadminPath() {
        return this.getCommandPath("wsadmin");
    }

    @Override
    public String getVersionInfoPath() {
        return this.getCommandPath("versionInfo");
    }

    @Override
    public String getStartServerPath() {
        return this.getCommandPath("startServer");
    }

    @Override
    public String getStopServerPath() {
        return this.getCommandPath("stopServer");
    }

    @Override
    public String getServerStatusPath() {
        return this.getCommandPath("serverStatus");
    }

    private String getCommandPath(String string) {
        String string2 = this.getCellHost().getOs().getFileSeparator();
        String string3 = this.getCellHost().getOs().getScriptExtension();
        return this.getWasHome() + string2 + "bin" + string2 + string + string3;
    }

    public boolean runWithDaemon() {
        return this.runWithDaemon;
    }

    public void setRunWithDaemon(boolean bl) {
        this.runWithDaemon = bl;
    }

    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public PythonManagingContainer getManagingContainer() {
        return this;
    }

    public CmdLine getScriptCommandLine(OverthereFile overthereFile) {
        CmdLine cmdLine = new CmdLine();
        cmdLine.addArgument(this.getWsadminPath());
        if (this.getUsername() != null && !this.getUsername().trim().isEmpty()) {
            cmdLine.addArgument("-user");
            cmdLine.addArgument(this.getUsername());
            if (this.getPassword() != null && !this.getPassword().isEmpty()) {
                cmdLine.addArgument("-password");
                cmdLine.addPassword(this.getPassword());
            }
        }
        if (this.getPort() != 0) {
            cmdLine.addArgument("-port");
            cmdLine.addArgument(Integer.toString(this.getPort()));
        }
        cmdLine.addArgument("-lang");
        cmdLine.addArgument("jython");
        cmdLine.addArgument("-f");
        cmdLine.addArgument(overthereFile.getPath());
        return cmdLine;
    }

    public String getRuntimePath() {
        return "was/runtime";
    }

    public String getInspectScript() {
        return this.inspectScript;
    }

    public List<Step> controlTaskDispatch(String string, Map<String, String> map) {
        return ControlTaskDelegate.dispatch((String)string, map, (ConfigurationItem)this, (Container)this);
    }

    @Inspect
    public void inspect(InspectionContext inspectionContext) {
        if (!this.skipTopologyDiscovery) {
            inspectionContext.addStep((Step)new CheckWasInstallationStep(this));
            inspectionContext.addStep((Step)new GetWasVersionStep(this));
        }
        inspectionContext.addStep((Step)new DiscoveryWasTopologyStep(this, this.skipTopologyDiscovery));
        if (!this.performOnlyTopologyDiscovery) {
            if (this.deployedTypesToDiscover != null && !this.deployedTypesToDiscover.isEmpty()) {
                DelegatedInspectionHelper.discoverDeployeds(this, inspectionContext, this.deployedTypesToDiscover);
            } else {
                DelegatedInspectionHelper.discoverDeployeds(this, inspectionContext);
            }
        }
    }
}

