/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatedInspectionHelper {
    public static final String DISCOVER_SCRIPT_PROPERTY_NAME = "discoverScript";
    private static Logger logger = LoggerFactory.getLogger(DelegatedInspectionHelper.class);

    public static void discoverDeployeds(PythonManagedContainer pythonManagedContainer, InspectionContext inspectionContext) {
        DelegatedInspectionHelper.discoverDeployeds(pythonManagedContainer, inspectionContext, DescriptorRegistry.getSubtypes((Type)Type.valueOf(PythonManagedDeployed.class)));
    }

    public static void discoverDeployeds(PythonManagedContainer pythonManagedContainer, InspectionContext inspectionContext, Iterable<Type> iterable) {
        Multimap<Integer, PythonInspectionStep> multimap = DelegatedInspectionHelper.newSortedKeyMultimapForSteps();
        Type type = pythonManagedContainer.getType();
        for (Type type2 : iterable) {
            Descriptor descriptor = type2.getDescriptor();
            logger.debug("Checking whether type [{}] is not virtual", (Object)type2);
            if (descriptor.isVirtual()) continue;
            Type type3 = descriptor.getContainerType();
            Type type4 = Type.valueOf(WasContainer.class);
            logger.debug("Checking whether type [{}] is instance of type [{}]", (Object)type3, (Object)type4);
            if (!type.instanceOf(type4)) continue;
            logger.debug("Checking whether type [{}] has a discoveryScript property", (Object)type2);
            PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(DISCOVER_SCRIPT_PROPERTY_NAME);
            if (propertyDescriptor == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a default value", (Object)type2);
            Object object = propertyDescriptor.getDefaultValue();
            if (object == null) continue;
            logger.debug("Checking whether the discoverScript property of type [{}] has a string value", (Object)descriptor.getType());
            if (!(object instanceof String)) continue;
            String string = (String)object;
            logger.debug("Adding inspection step using script {} for container {}", (Object)string, (Object)pythonManagedContainer);
            HashMap hashMap = Maps.newHashMap();
            hashMap.put("container", pythonManagedContainer);
            PythonManagedDeployed pythonManagedDeployed = (PythonManagedDeployed)descriptor.newInstance();
            hashMap.put("prototype", pythonManagedDeployed);
            PythonInspectionStep pythonInspectionStep = new PythonInspectionStep((ConfigurationItem)pythonManagedContainer, pythonManagedContainer.getManagingContainer(), string, (Map)hashMap, "Discover objects of type " + type2 + " on " + pythonManagedContainer);
            multimap.put((Object)pythonManagedDeployed.getDiscoverOrder(), (Object)pythonInspectionStep);
        }
        for (Type type2 : multimap.values()) {
            inspectionContext.addStep((Step)type2);
        }
    }

    private static Multimap<Integer, PythonInspectionStep> newSortedKeyMultimapForSteps() {
        return Multimaps.newListMultimap(new TreeMap(), (Supplier)new Supplier<List<PythonInspectionStep>>(){

            public List<PythonInspectionStep> get() {
                return Lists.newArrayList();
            }
        });
    }
}

