/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import java.util.Set;

@Metadata(description="A WebSphere Application Server deployment manager (WAS ND)", inspectable=true)
public class DeploymentManager
extends BaseCell {
    @Property(description="WebSphere nodes in the cell", asContainment=true)
    private Set<NodeAgent> nodeAgents = Sets.newHashSet();
    @Property(description="WebSphere clusters in the cell", asContainment=true, required=false)
    private Set<Cluster> clusters = Sets.newHashSet();

    @Override
    public String getCellName() {
        return this.getName();
    }

    @Override
    public Set<? extends Node> getNodes() {
        return this.nodeAgents;
    }

    public void addNode(NodeAgent nodeAgent) {
        this.nodeAgents.add(nodeAgent);
    }

    public Set<Cluster> getClusters() {
        return this.clusters;
    }

    public void addCluster(Cluster cluster) {
        this.clusters.add(cluster);
    }

    @Override
    public String getContainmentPath() {
        return "/Cell:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Cell";
    }

    @Override
    public String getWasTargetType() {
        return "Cell";
    }

    @Override
    public String getShortTypeDescription() {
        return "cell";
    }
}

