/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Server;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere server managed by a node that is part of a deployment manager (WAS ND)")
public class ManagedServer
extends BaseContainer
implements Server {
    @Property(asContainment=true, label="WebSphere node", description="Node on which the server runs")
    private NodeAgent node;

    public NodeAgent getNode() {
        return this.node;
    }

    public void setNode(NodeAgent nodeAgent) {
        this.node = nodeAgent;
    }

    @Override
    public Cell getCell() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object[])new Object[]{this});
        return this.getNode().getCell();
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object[])new Object[]{this});
        return this.getCell().getName();
    }

    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object[])new Object[]{this});
        return this.getNode().getName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this.getNode());
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getNodeName() + "/Server:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Server";
    }

    @Override
    public String getWasTargetType() {
        return "server";
    }

    @Override
    public String getShortTypeDescription() {
        return "managed server";
    }

    public Host getHost() {
        return this.getNode().getHost();
    }

    public List<Step> controlTaskDispatch(String string, Map<String, String> map) {
        return ControlTaskDelegate.dispatch((String)string, map, (ConfigurationItem)this, (Container)this);
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Preconditions.checkNotNull((Object)this.getNode(), (String)"%s has null node", (Object[])new Object[]{this});
        Preconditions.checkNotNull((Object)this.getCell(), (String)"%s has null cell", (Object[])new Object[]{this});
        String string = "cell=" + this.getCellName() + ",node=" + this.getNodeName() + ",type=ApplicationManager,process=" + this.getName() + ",*";
        return Collections.singletonList(string);
    }
}

