/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.DerivedProperty;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere node agent.")
public class NodeAgent
extends BaseContainer
implements Node {
    @Property(required=true, asContainment=true, label="Deployment manager that manages this node agent")
    private DeploymentManager cell;
    @Property(required=true, defaultValue="was/base/synchronize-node.py", hidden=true)
    private String synchronizeScript;
    @Property(description="WebSphere servers in the node", asContainment=true, required=false)
    private Set<ManagedServer> servers = Sets.newHashSet();
    @Property(description="WebSphere web servers in the node", asContainment=true, required=false)
    private Set<ManagedWebServer> webServers = Sets.newHashSet();

    public Host getHost() {
        return this.getCell().getHost();
    }

    public List<Step> controlTaskDispatch(String string, Map<String, String> map) {
        return ControlTaskDelegate.dispatch((String)string, map, (ConfigurationItem)this, (Container)this);
    }

    public Set<ManagedServer> getServers() {
        return this.servers;
    }

    public void addServer(ManagedServer managedServer) {
        this.servers.add(managedServer);
    }

    public Set<ManagedWebServer> getWebServers() {
        return this.webServers;
    }

    public void addWebServer(ManagedWebServer managedWebServer) {
        this.webServers.add(managedWebServer);
    }

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public void setCell(DeploymentManager deploymentManager) {
        this.cell = deploymentManager;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        return this.getCell().getCellName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this);
    }

    @Override
    @DerivedProperty(value="nodeName")
    public String getNodeName() {
        return this.getName();
    }

    public String getSynchronizeScript() {
        return this.synchronizeScript;
    }

    public void setSynchronizeScript(String string) {
        this.synchronizeScript = string;
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getName();
    }

    @Override
    public String getShortTypeDescription() {
        return "node";
    }

    @Override
    public String getWasConfigIdType() {
        return "Node";
    }

    @Override
    public String getWasTargetType() {
        return "Node";
    }
}

