/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.container.Server;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryWasTopologyStep
extends PythonInspectionStep {
    private Cell cell;
    private boolean skipDiscovery;

    public DiscoveryWasTopologyStep(BaseCell baseCell, boolean bl) {
        super((ConfigurationItem)baseCell, (PythonManagingContainer)baseCell, baseCell.getInspectScript(), DiscoveryWasTopologyStep.createPythonVars(baseCell), "Inspect " + baseCell);
        this.cell = baseCell;
        this.skipDiscovery = bl;
    }

    private static Map<String, Object> createPythonVars(Cell cell) {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("container", cell);
        return hashMap;
    }

    public StepExitCode execute(ExecutionContext executionContext) throws Exception {
        if (this.cell instanceof DeploymentManager) {
            DeploymentManager deploymentManager = (DeploymentManager)this.cell;
            if (this.skipDiscovery) {
                for (Node wasContainer : deploymentManager.getNodes()) {
                    executionContext.getInspectionContext().discovered((ConfigurationItem)wasContainer);
                    executionContext.getInspectionContext().inspected((ConfigurationItem)wasContainer);
                    for (Server server : ((NodeAgent)wasContainer).getServers()) {
                        executionContext.getInspectionContext().discovered((ConfigurationItem)server);
                        executionContext.getInspectionContext().inspected((ConfigurationItem)server);
                    }
                    for (ManagedWebServer managedWebServer : ((NodeAgent)wasContainer).getWebServers()) {
                        executionContext.getInspectionContext().discovered((ConfigurationItem)managedWebServer);
                        executionContext.getInspectionContext().inspected((ConfigurationItem)managedWebServer);
                    }
                }
                for (Cluster cluster : deploymentManager.getClusters()) {
                    executionContext.getInspectionContext().discovered((ConfigurationItem)cluster);
                    executionContext.getInspectionContext().inspected((ConfigurationItem)cluster);
                }
                return StepExitCode.SUCCESS;
            }
            deploymentManager.getNodes().clear();
            deploymentManager.getClusters().clear();
        }
        return super.execute(executionContext);
    }
}

