/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.DelegatedInspectionHelper;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.step.CheckWasInstallationStep;
import com.xebialabs.deployit.plugin.was.step.DiscoveryWasTopologyStep;
import com.xebialabs.deployit.plugin.was.step.GetWasVersionStep;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import java.util.List;
import java.util.Map;

@Metadata(description="Base class for a Webshpere Cell", inspectable=true)
public abstract class BaseCell
extends BaseContainer
implements Cell {
    @Property(required=true, asContainment=true, description="Host on which the unmanaged WAS server runs")
    @InspectionProperty(required=true)
    private Host host;
    @Property(required=true, label="WebSphere Installation Path", description="Root path of the WebSphere installation path. e.g. /opt/ws/6.1/appserver/profiles/AppSrv01", size=Property.Size.MEDIUM)
    @InspectionProperty(required=true)
    private String wasHome;
    @Property(required=false, label="Administrative port", description="TCP port which is used to login to the WebSphere Administration, default is 8880")
    @InspectionProperty(required=false)
    private int port;
    @Property(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Administration.")
    @InspectionProperty(required=false)
    private String username;
    @Property(required=false, password=true, label="Administrative password", description="Password which is used to login to the WebSphere Administration.")
    @InspectionProperty(required=false)
    private String password;
    @Property(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;
    @Property(required=false, label="Run with daemon", description="Set to true to execute commands with the Python daemon", defaultValue="true", hidden=true)
    private boolean runWithDaemon;
    @Property(required=false, hidden=true, defaultValue="was/container/discover-inspect-topology-lib.py", description="List of scripts to appended to runtime script")
    private List<String> libraryScripts = Lists.newArrayList();
    @Property(hidden=true, defaultValue="was/container/discover-inspect-topology.py", description="Inspect script for Cell")
    private String inspectScript;
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";
    public boolean skipTopologyDiscovery;
    public boolean performOnlyTopologyDiscovery;
    public List<Type> deployedTypesToDiscover;

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    @Override
    public WasVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(WasVersion version) {
        this.version = version;
    }

    @Override
    public Cell getCell() {
        return this;
    }

    @Override
    public Host getCellHost() {
        return this.host;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getConfigDirPath() {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        return this.getWasHome() + fileSep + CONFIG_DIR_NAME;
    }

    @Override
    public String getPluginFilePath() {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        return this.getConfigDirPath() + fileSep + "cells" + fileSep + PLUGIN_FILENAME;
    }

    @Override
    public String getWsadminPath() {
        return this.getCommandPath("wsadmin");
    }

    @Override
    public String getVersionInfoPath() {
        return this.getCommandPath("versionInfo");
    }

    @Override
    public String getStartServerPath() {
        return this.getCommandPath("startServer");
    }

    @Override
    public String getStopServerPath() {
        return this.getCommandPath("stopServer");
    }

    @Override
    public String getServerStatusPath() {
        return this.getCommandPath("serverStatus");
    }

    private String getCommandPath(String command) {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        String scriptExt = this.getCellHost().getOs().getScriptExtension();
        return this.getWasHome() + fileSep + "bin" + fileSep + command + scriptExt;
    }

    public boolean runWithDaemon() {
        return this.runWithDaemon;
    }

    public void setRunWithDaemon(boolean runWithDaemon) {
        this.runWithDaemon = runWithDaemon;
    }

    public List<String> getLibraryScripts() {
        return this.libraryScripts;
    }

    public PythonManagingContainer getManagingContainer() {
        return this;
    }

    public CmdLine getScriptCommandLine(OverthereFile pyFile) {
        CmdLine commandLine = new CmdLine();
        commandLine.addArgument(this.getWsadminPath());
        if (this.getUsername() != null && !this.getUsername().trim().isEmpty()) {
            commandLine.addArgument("-user");
            commandLine.addArgument(this.getUsername());
            if (this.getPassword() != null && !this.getPassword().isEmpty()) {
                commandLine.addArgument("-password");
                commandLine.addPassword(this.getPassword());
            }
        }
        if (this.getPort() != 0) {
            commandLine.addArgument("-port");
            commandLine.addArgument(Integer.toString(this.getPort()));
        }
        commandLine.addArgument("-lang");
        commandLine.addArgument("jython");
        commandLine.addArgument("-f");
        commandLine.addArgument(pyFile.getPath());
        return commandLine;
    }

    public String getRuntimePath() {
        return "was/runtime";
    }

    public String getInspectScript() {
        return this.inspectScript;
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch((String)name, args, (ConfigurationItem)this, (Container)this);
    }

    @Inspect
    public void inspect(InspectionContext ctx) {
        if (!this.skipTopologyDiscovery) {
            ctx.addStep((Step)new CheckWasInstallationStep(this));
            ctx.addStep((Step)new GetWasVersionStep(this));
        }
        ctx.addStep((Step)new DiscoveryWasTopologyStep(this, this.skipTopologyDiscovery));
        if (!this.performOnlyTopologyDiscovery) {
            if (this.deployedTypesToDiscover != null && !this.deployedTypesToDiscover.isEmpty()) {
                DelegatedInspectionHelper.discoverDeployeds(this, ctx, this.deployedTypesToDiscover);
            } else {
                DelegatedInspectionHelper.discoverDeployeds(this, ctx);
            }
        }
    }
}

