#
import sys
import traceback

def isNetworkDeploymentEdition(container):
    return container.wasConfigIdType == 'Cell'

def inspectCellName(container):
    print "Inspecting cell %s" % (container.name)
    
    # Inspect cell name
    try:
        cell = AdminConfig.list('Cell')
        cellName = AdminConfig.showAttribute(cell, 'name');
    except:
        print >> sys.stderr, "Cannot get cell information. Have you entered the correct username and password to administer WebSphere Application Server?"
        traceback.print_exc()
        sys.exit(1)
    
    if container.wasConfigIdType == 'Cell':
        if container.name != cellName:
            print >> sys.stderr, "Cell name is %s instead of %s. Please set the correct ID for the was.DeploymentManager CI." % (cellName, container.name)
            sys.exit(1)
    else:
        inspected('cellName', cellName)
        server = AdminTask.listServers('[-serverType APPLICATION_SERVER ]')
        serverName = server[0:server.find("(")]
        
        if container.name != serverName:
            print >> sys.stderr, "Server name is %s instead of %s. Please set the correct ID for the was.UnmanagedServer CI." % (serverName, container.name)
            sys.exit(1)

########################################################################################################################
#
# Function to discover and inspect a Websphere Base installation.
# Managed Webservers are automatically discovered/inspected.
# Use the callback mechanism to inspect additional properties.
#
# container : The container (was.UnmanagedServer).
#
# webserverInspectCallback : if the caller wishes to inspect additional information for webserver.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the webserver.
#
########################################################################################################################
def discoverAndInspectBaseEditionContainers(container, webserverInspectCallback=None):
    nodes = wsadminToList(AdminConfig.list('Node'))
    if container.wasConfigIdType != 'Cell' and len(nodes) == 1:
        # Discover SA
        inspected('nodeName', AdminConfig.showAttribute(nodes[0], 'name'))
        webservers = wsadminToList(AdminConfig.list("WebServer"))
        for ws in webservers:
            server = AdminConfig.showAttribute(ws, 'server')
            wsId = container.id + "/" + AdminConfig.showAttribute(server, 'name')
            discovered(wsId, 'was.ManagedWebServer')
            if webserverInspectCallback:
                webserverInspectCallback(wsId,ws)
            inspectedItem(wsId)

########################################################################################################################
#
# Function to discover and inspect a Websphere ND installation.
# Nodes, Application Servers, Managed Webservers and Clusters automatically discovered/inspected.
# Use the callback mechanism to inspect additional properties.
#
# container : The container (was.DeploymentManager).
#
# nodeInspectCallback : if the caller wishes to inspect additional information for the node.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the node.
#
# webserverInspectCallback : if the caller wishes to inspect additional information for webserver.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the webserver.
#
# appserverInspectCallback : if the caller wishes to inspect additional information for application server.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the application server.
#
# clusterInspectCallback : if the caller wishes to inspect additional information for cluster.
#     deployedId - id of discovered ci.
#     wasId - WAS id of the cluster.
#
#
########################################################################################################################
def discoverAndInspectNetworkDeploymentEditionContainers(container, nodeInspectCallback=None, webserverInspectCallback=None, appserverInspectCallback=None, clusterInspectCallback=None):
    nodes = wsadminToList(AdminConfig.list('Node'))
    # Discover ND
    # Discover was.NodeAgent instances - skip Nodes that have no corresponding NodeAgent
    nodeagents = AdminConfig.list('NodeAgent')
    for node in nodes:
        nodeName = AdminConfig.showAttribute(node, 'name')
        if nodeagents.find('/nodes/%s/servers' % (nodeName)) != -1:
            nodeId = '%s/%s' % (container.id, nodeName)
            discovered(nodeId, 'was.NodeAgent')
            if nodeInspectCallback:
                nodeInspectCallback(nodeId, node)
            nodeServers = wsadminToList(AdminConfig.getid('/Node:%s/Server:/' % (nodeName)))
            for s in nodeServers:
                wasServerType = AdminConfig.showAttribute(s, 'serverType')
                nodeServerId = nodeId + '/' + AdminConfig.showAttribute(s, 'name')
                if wasServerType == 'WEB_SERVER':
                    discovered(nodeServerId, 'was.ManagedWebServer')
                    if webserverInspectCallback:
                        webserverInspectCallback(nodeServerId,s)
                    inspectedItem(nodeServerId)
                elif wasServerType == 'APPLICATION_SERVER':
                    discovered(nodeServerId, 'was.ManagedServer')
                    if appserverInspectCallback:
                        appserverInspectCallback(nodeServerId,s)
                    inspectedItem(nodeServerId)
                else:
                    continue
            inspectedItem(nodeId)
    
    # Discover was.Cluster instances
    clusters = wsadminToList(AdminConfig.list('ServerCluster'))
    for cluster in clusters:
        clusterName = AdminConfig.showAttribute(cluster, 'name')
        clusterId = '%s/%s' % (container.id, clusterName)
        discovered(clusterId, 'was.Cluster')
        clusterServers = []
        clusterMembers = wsadminToList(AdminConfig.getid('/ServerCluster:%s/ClusterMember:/' % (clusterName)))
        for m in clusterMembers:
            clusterServers.append(container.id + '/' + AdminConfig.showAttribute(m, 'nodeName') + '/' + AdminConfig.showAttribute(m, 'memberName'))
        inspectedProperty(clusterId, 'servers', clusterServers)
        if clusterInspectCallback:
            clusterInspectCallback(clusterId,cluster)
        inspectedItem(clusterId)
