########################################################################################################################
#
# Function to discover and inspect datasources in all scopes.
#
# canHandleDatasourceTypeCallback : if the caller can handle the specific datasource. The callback is called for each
#                                   resource property on the datasource so that the function can figure out whether
#                                   it can handle the inspection of the datsource.
#     datasourceId - WAS id of the datasourceId
#     resourcePropertyName - resource property name
#     resourcePropertyId - WAS id of the resource property
#     container - Deployit container on which the datasource resides.
#
# dsInspectCallback : the inspection function that should be used. Default is the inspectDatasource function in this lib.
#     deployedId - id of discovered ci.
#     dsName - name of the datasource
#     dsId - WAS id for the datasource
#     container - Deployit container on which the datasource resides.
#
########################################################################################################################
def discoverAndInspectDatasources(canHandleDatasourceTypeCallback, dsInspectCallback=None):
    if dsInspectCallback is None:
        dsInspectCallback = inspectDatasource
    for c in findAllContainers(container):
        discoverAndInspectDatasourcesInContainer(c, canHandleDatasourceTypeCallback, dsInspectCallback)


def discoverAndInspectDatasourcesInContainer(container, canHandleDatasourceTypeCallback, dsInspectCallback):
    print "Retrieving list of JDBC DataSources in container %s" % (container.name)
    datasources = AdminConfig.getid('%s/JDBCProvider:/DataSource:/' % (container.containmentPath)).splitlines()
    for ds in datasources:
        print "Handling", ds
        dName = AdminConfig.showAttribute(ds, 'name')
        propertySet = AdminConfig.showAttribute(ds, 'propertySet')
        resourceProperties = AdminConfig.showAttribute(propertySet, 'resourceProperties')[1:-1].split()
        for resourceProperty in resourceProperties:
            pName = AdminConfig.showAttribute(resourceProperty, 'name')
            if canHandleDatasourceTypeCallback(ds,pName,resourceProperty,container):
                print "Discovered %s %s in container %s" % (prototype.type, dName, container.name)
                deployedId = container.id + '/' + dName
                discovered(deployedId, prototype.type)
                dsInspectCallback(deployedId, dName, ds, container)
                inspectedItem(deployedId)
                break


def inspectDatasource(deployedId, dsName, datasourceId, container):
   inspectedProperty(deployedId, 'jndiName', AdminConfig.showAttribute(datasourceId, 'jndiName'))
   inspectedProperty(deployedId, 'datasourceHelperClassname', AdminConfig.showAttribute(datasourceId, 'datasourceHelperClassname'))
   inspectedProperty(deployedId, 'jdbcProvider', AdminConfig.showAttribute(AdminConfig.showAttribute(datasourceId, 'provider'), 'name'))

   propertySet = AdminConfig.showAttribute(datasourceId, 'propertySet')
   resourceProperties = AdminConfig.showAttribute(propertySet, 'resourceProperties')[1:-1].split()
   for resourceProperty in resourceProperties:
       name = AdminConfig.showAttribute(resourceProperty, 'name')
       if name != 'name':
           value = AdminConfig.showAttribute(resourceProperty, 'value')
           inspectedProperty(deployedId, name, value)

   jaasName = AdminConfig.showAttribute(datasourceId, 'authDataAlias')
   authdataIds = AdminConfig.list('JAASAuthData').split();
   for authdataId in authdataIds:
       if AdminConfig.showAttribute(authdataId, 'alias') == jaasName:
           inspectedProperty(deployedId, 'username', AdminConfig.showAttribute(authdataId, 'userId'))

   connectionPool = AdminConfig.showAttribute(datasourceId, 'connectionPool')
   inspectedProperty(deployedId, 'ConnectionPool_connectionTimeout', AdminConfig.showAttribute(connectionPool, "connectionTimeout"))
   inspectedProperty(deployedId, 'ConnectionPool_maxConnections', AdminConfig.showAttribute(connectionPool, "maxConnections"))
   inspectedProperty(deployedId, 'ConnectionPool_minConnections', AdminConfig.showAttribute(connectionPool, "minConnections"))


