/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;

public class CheckWasInstallationStep
implements Step {
    private Cell cell;
    private boolean validInstallation;

    public CheckWasInstallationStep(Cell cell) {
        this.cell = cell;
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        OverthereConnection c = this.cell.getHost().getConnection();
        try {
            this.validInstallation = true;
            this.checkDirectoryExistence(ctx, c, this.cell.getWasHome());
            this.checkDirectoryExistence(ctx, c, this.cell.getConfigDirPath());
            this.checkFileExistenceAndExecutability(ctx, c, this.cell.getVersionInfoPath());
            this.checkFileExistenceAndExecutability(ctx, c, this.cell.getWsadminPath());
            StepExitCode stepExitCode = this.validInstallation ? StepExitCode.SUCCESS : StepExitCode.FAIL;
            return stepExitCode;
        }
        finally {
            c.close();
        }
    }

    protected void checkDirectoryExistence(ExecutionContext ctx, OverthereConnection c, String dirPath) {
        ctx.logOutput("Checking whether directory " + dirPath + " exists on " + this.cell.getHost());
        if (!c.getFile(dirPath).exists()) {
            ctx.logError("Directory " + dirPath + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        }
    }

    private void checkFileExistenceAndExecutability(ExecutionContext ctx, OverthereConnection c, String filePath) {
        ctx.logOutput("Checking whether file " + filePath + " exists on " + this.cell.getHost() + " exists" + (c.getHostOperatingSystem() == OperatingSystemFamily.UNIX ? " and is executable" : ""));
        if (!c.getFile(filePath).exists()) {
            ctx.logError("File " + filePath + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        } else if (c.getHostOperatingSystem() == OperatingSystemFamily.UNIX && !c.getFile(filePath).canExecute()) {
            ctx.logError("File " + filePath + " on " + this.cell.getHost() + " is not executable");
            this.validInstallation = false;
        }
    }

    public String getDescription() {
        return "Checking whether " + this.cell + " is a valid WebSphere Application Server installation";
    }
}

