def discoverAndInspectJmsProvider(container):
    jmsProviders = wsadminToList(AdminConfig.getid('%s/JMSProvider:/' % (container.containmentPath)))
    for provider in jmsProviders:
        deployedName = AdminConfig.showAttribute(provider, 'name')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectDeployedProperties(deployedId, deployedName, provider, prototype)
        inspectNestedJ2EEResourceProperties(deployedId, provider, "propertySet", "customProperties")
        inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectJmsProvider(c)