def discoverAndInspectResourceEnvironmentEntry(container):
    providerIdList = wsadminToList(AdminConfig.list('ResourceEnvironmentProvider', AdminConfig.getid(container.containmentPath)))
    for providerId in providerIdList:
        resEnvEntries = wsadminToList(AdminConfig.list("ResourceEnvEntry", providerId))
        for envEntry in resEnvEntries:
            deployedName = AdminConfig.showAttribute(envEntry, "name")
            deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectDeployedProperties(deployedId, deployedName, envEntry, prototype)
            inspectNestedResourceproperties(deployedId, envEntry, "provider")
            inspectNestedJ2EEResourceProperties(deployedId, envEntry, "propertySet", "customProperties")
            inspectedItem(deployedId)

def inspectNestedResourceproperties(deployedId, envEntry, nestedProperty):
    nestedPropId = AdminConfig.showAttribute(envEntry, nestedProperty)
    inspectedProperty(deployedId, nestedProperty, AdminConfig.showAttribute(nestedPropId, "name"))

for c in findAllContainers(container):
    discoverAndInspectResourceEnvironmentEntry(c)