def discoverAndInspectServerPort(container):
    containerId = AdminConfig.getid(container.containmentPath)
    serverName = container.name
    serverEntries = wsadminToList(AdminConfig.list( 'ServerEntry'))
    for serverEntry in serverEntries :
        sName = AdminConfig.showAttribute(serverEntry, "serverName")
        if sName == serverName:
            namedEndPoints = wsadminToList(AdminConfig.list( "NamedEndPoint" , serverEntry))
            for namedEndPoint in namedEndPoints:
                endPointName = AdminConfig.showAttribute(namedEndPoint, "endPointName" )
                endPoint = AdminConfig.showAttribute(namedEndPoint, "endPoint" )
                deployedId = container.id + '/' + endPointName
                discovered(deployedId, prototype.type)
                inspectDeployedProperties(deployedId, endPointName, endPoint, prototype)
                inspectedItem(deployedId)

for c in findAllContainers(container, onlyWasAppContainer=True):
    discoverAndInspectServerPort(c)