
def discoverAndInspectMailProvidersInContainer(container):
    containerId = AdminConfig.getid(container.containmentPath)
    mailProviders = wsadminToList(AdminConfig.list('MailProvider', containerId))
    for mailProvider in mailProviders:
        if mailProvider.find('Built-in Mail Provider(') != 1:
            deployedName = AdminConfig.showAttribute(mailProvider, 'name')
            deployedId = container.id + '/' + deployedName
            discovered(deployedId, prototype.type)
            inspectDeployedProperties(deployedId, deployedName, mailProvider, prototype)
            if getVersion(container) != 'WAS_61':
                cp = AdminConfig.showAttribute(mailProvider, 'classpath')
                if cp == '[]':
                    cp = ""
                inspectedProperty(deployedId, 'classpath', cp)
                inspectedProperty(deployedId, 'isolatedClassLoader', AdminConfig.showAttribute(mailProvider, 'isolatedClassLoader'))
            inspectNestedJ2EEResourceProperties(deployedId, mailProvider, "propertySet", "customProperties")
            inspectedItem(deployedId)
        else:
            print "WARN: Ignoring built-in mail provider '%s'" % (mailProvider)

for c in findAllContainers(container):
    discoverAndInspectMailProvidersInContainer(c)