package com.xebialabs.deployit.plugin.was.util;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WasVersionInfoParser {

    public int majorVersion = -1;
    public int minorVersion = -1;
    
    public WasVersionInfoParser() {}
    
    public WasVersionInfoParser parse(List<String> versionInfoOutput) {
        boolean scanningWasInfo = false;
        for (String eachLine : versionInfoOutput) {
                if (eachLine.startsWith("Name")) {
                    // "Name<spaces><non-space><rest of name>"
                    String[] matches = regexMatch(eachLine, "Name\\s+(\\w.+)");
                    if (matches != null && matches.length == 1
                            && matches[0].startsWith("IBM WebSphere Application Server")) {
                        scanningWasInfo = true;
                    } else {
                        scanningWasInfo = false;
                    }
                } else if (scanningWasInfo && eachLine.startsWith("Version")) {
                    String[] matches = regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*");
                    if (matches != null && matches.length == 2) {
                        majorVersion = Integer.parseInt(matches[0]);
                        minorVersion = Integer.parseInt(matches[1]);
                        return this;
                    }
                }
            }
        return this;
    }
    
    public WasVersionInfoParser parse(String[] versionInfoOutput) {
        return parse(Arrays.asList(versionInfoOutput));
    }

    public boolean isSuccess() {
        return majorVersion != -1 && minorVersion != -1;
    }

    private static String[] regexMatch(String str, String regexPattern) {
        Matcher m = Pattern.compile(regexPattern).matcher(str);
        if (m.matches()) {
            String[] matches = new String[m.groupCount()];
            for (int i = 0; i < matches.length; i++) {
                matches[i] = m.group(i + 1);
            }
            return matches;
        } else {
            return null;
        }
    }

}
