package com.xebialabs.deployit.plugin.was.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.overthere.OverthereFile;

import java.util.Map;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedHelper.syncNodes;

@SuppressWarnings("serial")
@Metadata(virtual = true, description = "Base class for all extensible deployed artifact configuration items.")
@Placeholders
public class ExtensibleDeployedArtifact extends ExtensibleDeployed<DeployableArtifact> implements DerivedArtifact<DeployableArtifact> {

    private OverthereFile derivedFile;

    @Property(hidden = true, defaultValue = "Rollout", description = "The word that is used to prefix a step description for the rollout operation.")
    private String rolloutEditionedVerb;

    @Property(hidden = true, defaultValue = "20", description = "The order in which a rollout step will be executed.")
    private int rolloutEditionedOrder;

    @Property(hidden = true, required = false, description = "Python script invoked to rollout a Java EE artifact.")
    private String rolloutEditionedScript;

    @Property(hidden = true, defaultValue = "10", description = "The order in which a create step for Editioned application will be executed(was85nd only).")
    private int createEditionedOrder;

    @Property(description = "A Map containing all the placeholders mapped to their values. Special values are <ignore> or <empty>", required = false)
    private Map<String, String> placeholders = newHashMap();

    @Override
    public OverthereFile getFile() {
        return derivedFile;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.derivedFile = file;
    }

    @Override
    public DeployableArtifact getSourceArtifact() {
        return getDeployable();
    }

    @Override
    public Map<String, String> getPlaceholders() {
        return placeholders;
    }

    @Override
    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void createEditioned(DeploymentPlanningContext ctx, Delta delta, CheckpointInfo checkpoint) {
        addStep(ctx, createEditionedOrder, getCreateScript(), getCreateVerb(), checkpoint);
        addStep(ctx, rolloutEditionedOrder, rolloutEditionedScript, rolloutEditionedVerb, checkpoint);
    }

    public void modify(DeploymentPlanningContext ctx, Delta delta, CheckpointInfo checkpoint) {
        if (addStep(ctx, getModifyOrder(), getModifyScript(), getModifyVerb(), checkpoint)) {
            syncNodes(ctx, getSyncAfterModifyOrder(), getContainer());
        } else {
            ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact) delta.getPrevious();
            ExtensibleDeployedArtifact current = (ExtensibleDeployedArtifact) delta.getDeployed();
            if (current.<Boolean>getProperty("isEdition")) {
                current.createEditioned(ctx, delta, checkpoint);
                previous.destroy(ctx, delta, checkpoint, false);
            } else {
                if (checkpoint == null) {
                    previous.destroy(ctx, delta, null, true);
                    current.create(ctx, delta, null);
                } else {
                    previous.destroy(ctx, delta);
                    current.create(ctx, delta);
                }
            }
        }
    }
}
