/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.upgrade;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAS410ModuleMigration
extends Upgrade {
    public static final List<String> TYPES_TO_UPGRADE = Lists.newArrayList((Object[])new String[]{"was.Ear", "was.EarModule", "was.War", "was.WarModule"});
    private static final Logger logger = LoggerFactory.getLogger(WAS410ModuleMigration.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting WAS plugin 4.1.0 upgrade -- Migrate Module type ***");
        this.upgradeApplicationModules(repository);
        logger.info("*** Done WAS plugin 4.1.0 upgrade -- Migrate Module type ***");
        return true;
    }

    private void upgradeApplicationModules(RawRepository repository) {
        for (String typeToUpgrade : TYPES_TO_UPGRADE) {
            List moduleNodes = repository.findNodesByType(Type.valueOf((String)typeToUpgrade));
            try {
                for (Node moduleNode : moduleNodes) {
                    if (!moduleNode.hasProperty("webModuleSessionTimeout")) continue;
                    logger.info("Migrating Module: {}", (Object)moduleNode.getPath());
                    this.createSessionManager(repository, moduleNode);
                }
            }
            catch (RepositoryException e) {
                throw new UpgradeException("*** Failed WAS plugin 4.1.0 upgrade -- Migrate Module type ***", (Exception)((Object)e));
            }
        }
    }

    private void createSessionManager(RawRepository repository, Node moduleNode) throws RepositoryException {
        logger.info("Creating embedded was.SessionManager at [{}/sessionManager]", (Object)moduleNode.getPath().substring(1));
        Node sessionManagerNode = moduleNode.addNode("sessionManager");
        sessionManagerNode.addMixin("deployit:configurationItem");
        sessionManagerNode.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        if (moduleNode.hasProperty("deployable")) {
            sessionManagerNode.setProperty("$configuration.item.type", "was.SessionManager");
            Node deployableModuleNode = moduleNode.getProperty("deployable").getNode();
            if (!deployableModuleNode.hasNode("sessionManager")) {
                this.createSessionManager(repository, deployableModuleNode);
            }
            sessionManagerNode.setProperty("deployable", deployableModuleNode.getNode("sessionManager"));
        } else {
            sessionManagerNode.setProperty("$configuration.item.type", "was.SessionManagerSpec");
        }
        if (moduleNode.hasProperty("webModuleSessionTimeout")) {
            sessionManagerNode.setProperty("TuningParams_invalidationTimeout", moduleNode.getProperty("webModuleSessionTimeout").getString());
        }
        sessionManagerNode.setProperty("$lastModified", Calendar.getInstance());
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"was-plugin", (String)"4.1.0");
    }
}

