
def mailProviderArgs(deployed):
    args = toAdminConfigArgs(deployed.getExposedProperties(True))
    if not deployed.description:
        args.extend([['description', '']])
    if getVersion(deployed.container) != 'WAS_61':
        if deployed.isolatedClassLoader:
            args.extend([['classpath', mapToEmptyList(deployed.classpath)], ['nativepath', mapToEmptyList(deployed.nativepath)], ['isolatedClassLoader', 'true']])
        else:
            args.extend([['isolatedClassLoader', 'false']])

    return args

def findMailObject(name, mailObjectList, property):
    mailList = [m for m in mailObjectList if AdminConfig.showAttribute(m, property) == name]
    if mailList:
        return mailList[0]
    return None

def findMailProvider(container, name):
    providerContainmentPath = '%s/MailProvider:/' % (container.containmentPath)
    providers = validateNotEmpty(wsadminToList(AdminConfig.getid(providerContainmentPath)), "Cannot locate any Mail Provider with containment path '%s'" % (providerContainmentPath))
    providers = [p for p in providers if AdminConfig.showAttribute(p, 'name') == name]
    if providers:
        if len(providers) > 1:
            raise "More than one MailProvider found with name '%s' under containment path: '%s'" % (name, container.containmentPath)
        return providers[0]
    return None

def getMailObject(deployed, mailObject, providerName):
    providerId = findMailProvider(deployed.container, providerName)
    if 'MailProvider' == mailObject:
        mailObjectId = providerId
    else:
        mailObjectList = wsadminToList(AdminConfig.list(mailObject, providerId))
        mailObjectId = findMailObject(providerName, mailObjectList, 'name')
    return mailObjectId

def propsToArgs(deployed, properties):
    return [[p, noneToEmpty(getattr(deployed, p))] for p in properties]

def mailSessionArgs(deployed, provider):
    protocolProviders = AdminConfig.showAttribute(provider, 'protocolProviders')
    allProtocolProviders = wsadminToList(protocolProviders)
    args = toAdminConfigArgs(deployed.getExposedProperties(True))
    if deployed.mailStoreHost:
        args.extend(propsToArgs(deployed, ['mailStoreHost', 'mailStoreUser', 'mailStorePassword']))
        storeProtocolProvider = validateNotEmpty(findMailObject(deployed.mailStoreProtocol, allProtocolProviders, 'protocol'), "Cannot locate mail store protocol '%s' on mail provider '%s' in container '%s'" % (deployed.mailStoreProtocol, deployed.provider, deployed.container.name))
        args.extend([['mailStoreProtocol', storeProtocolProvider]])
    if deployed.mailTransportHost:
        args.extend(propsToArgs(deployed, ['mailTransportHost', 'mailFrom', 'mailTransportUser', 'mailTransportPassword']))
        transportProtocolProvider = validateNotEmpty(findMailObject(deployed.mailTransportProtocol, allProtocolProviders, 'protocol'), "Cannot locate mail transport protocol '%s' on mail provider '%s' in container '%s'" % (deployed.mailTransportProtocol, deployed.provider, deployed.container.name))
        args.extend([['mailTransportProtocol', transportProtocolProvider]])
    return args

def getMailSessionIdsForProvider(deployed):
    providerId = getMailObject(deployed, 'MailProvider', deployed.name)
    return wsadminToList(AdminConfig.list('MailSession', providerId))

def destroyMailObject(deployed, mailObject):
    mailObjectId = getMailObject(deployed, mailObject, deployed.name)
    if mailObjectId:
        print "Destroying '%s' '%s' in container '%s'" % (mailObject, deployed.name, deployed.container.name)
        AdminConfig.remove(mailObjectId)
    else:
        print "No '%s' '%s' found, Nothing to do" % (mailObject, deployed.name)

def modifyMailObject(deployed, args, mailObject):
    mailObjectId = getMailObject(deployed, mailObject, deployed.name)
    if mailObjectId is None:
        raise "Cannot locate '%s' '%s' in container '%s'" % (mailObject, deployed.name, deployed.container.name)
    print "Modifying '%s' '%s' in container '%s' with args '%s'" % (mailObject, mailObjectId, deployed.container.name, args)
    if getVersion(deployed.container) == 'WAS_61':
        AdminConfig.modify(mailObjectId, args)
    else:
        AdminConfig.resetAttributes(mailObjectId, args)
    removeJ2EEResourceProperties(mailObjectId)
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(mailObjectId, deployed)
