/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.container;

import java.util.*;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.ControlTaskDelegate;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.util.ClusterMembersFilter;

import static com.google.common.base.Preconditions.checkNotNull;

@SuppressWarnings("serial")
@Metadata(description = "A WebSphere cluster managed by a deployment manager (WAS ND)")
public class Cluster extends BaseContainer implements WasAppContainer {

    @Property(asContainment = true, label = "Deployment manager that manages this this cluster")
    private DeploymentManager cell;

    @Property(required = false, label = "Cluster members", description = "Servers that are part of this cluster", candidateValuesFilter=ClusterMembersFilter.SERVERS_BY_CELL_AND_TYPE)
    private Set<ManagedServer> servers;

    @Property(required = false, hidden=true, label ="Server type", description = "Cluster server type. Possible values are: PROXY_SERVER, APPLICATION_SERVER, ONDEMAND_ROUTER")
    private ServerType serverType;

    @Override
    public DeploymentManager getCell() {
        return cell;
    }

    @Override
    public PythonManagingContainer getManagingContainer() {
        return getCell();
    }

    @Override
    public String getCellName() {
        checkNotNull(getCell(), "%s has null cell", this);

        return getCell().getName();
    }

    @Override
    public Host getHost() {
        return getCell().getHost();
    }

    public List<Step> controlTaskDispatch(String name, Map<String, String> args) {
        return ControlTaskDelegate.dispatch(name, args, this, this);
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public void setServers(Set<ManagedServer> servers) {
        this.servers = servers;
    }

    public Set<ManagedServer> getServers() {
        return servers;
    }

    public ServerType getServerType() {
        return serverType;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public Map<NodeAgent, List<String>> getServerNamesPerNode() {
        Map<NodeAgent, List<String>> serverNamesPerNode = new HashMap<NodeAgent, List<String>>();
        if(servers != null) {
            for (ManagedServer server : servers) {
                NodeAgent node = server.getNode();
                checkNotNull(node, "%s has null node", server);

                List<String> serverNames = serverNamesPerNode.get(node);
                if (serverNames == null) {
                    serverNames = new ArrayList<String>();
                    serverNamesPerNode.put(node, serverNames);
                }
                serverNames.add(server.getName());
            }
        }
        return serverNamesPerNode;
    }

    @Override
    public Set<Node> getNodes() {
        Set<Node> nodes = new HashSet<Node>();
        if(servers != null) {
            for (ManagedServer server : servers) {
                nodes.add(server.getNode());
            }
        }
        return nodes;
    }

    @Override
    public String getContainmentPath() {
        return "/ServerCluster:" + getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "ServerCluster";
    }

    @Override
    public String getWasTargetType() {
        return "cluster";
    }

    @Override
    public String getShortTypeDescription() {
        return "cluster";
    }

    @Override
    public List<String> getApplicationManagerObjectNames() {
        Map<NodeAgent, List<String>> serverNamesPerNode = getServerNamesPerNode();
        ArrayList<String> applicationManagerObjectNames = new ArrayList<String>();
        for (Map.Entry<NodeAgent, List<String>> each : serverNamesPerNode.entrySet()) {
            NodeAgent eachNode = each.getKey();
            List<String> eachNodeServerNames = each.getValue();
            for (String eachServerName : eachNodeServerNames) {
                applicationManagerObjectNames.add("cell=" + getCellName() + ",node=" + eachNode.getName() + ",type=ApplicationManager,process=" + eachServerName + ",*");
            }
        }
        return applicationManagerObjectNames;
    }

}
