package com.xebialabs.deployit.plugin.was.upgrade;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.was.deployed.jms.mq.TargetClient;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;

public class WAS410WmqConnectionFactoryMigration extends Upgrade {

    public static final List<String> TYPES_TO_UPGRADE = Lists.newArrayList("was.WmqQueueConnectionFactory", "was.WmqQueueConnectionFactorySpec");

    @Override
    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***");

        upgradeWmqQueueConnectionFactories(repository);

        logger.info("*** Done WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***");
        return true;
    }

    private void upgradeWmqQueueConnectionFactories(final RawRepository repository) {
        for (String typeToUpgrade : TYPES_TO_UPGRADE) {
            List<Node> wmqQcfNodes = repository.findNodesByType(Type.valueOf(typeToUpgrade));
            try {
                for (Node wmqQcfNode : wmqQcfNodes) {
                    if (!wmqQcfNode.hasProperty("sslConfiguration")) continue;

                    logger.info("Migrating WMQQueueConnectionFactory: {}", wmqQcfNode.getPath());

                    String sslConfigurationName = "";
                    Property sslConfiguration = wmqQcfNode.getProperty("sslConfiguration");
                    Node sslConfigurationNode = sslConfiguration.getNode();
                    if(sslConfigurationNode != null && sslConfigurationNode.hasProperty("sslConfigName")) {
                        sslConfigurationName = sslConfigurationNode.getProperty("sslConfigName").getString();
                    }

                    sslConfiguration.remove();
                    wmqQcfNode.setProperty("sslConfigurationName", sslConfigurationName);
                }

            } catch (RepositoryException e) {
                throw new UpgradeException("*** Failed WAS plugin 4.1.0 upgrade -- Migrate WMQQueueConnectionFactory type ***", e);
            }
        }
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("was-plugin","4.1.0");
    }

    private static final Logger logger = LoggerFactory.getLogger(WAS410WmqConnectionFactoryMigration.class);
}
