from com.xebialabs.deployit.plugin.api.deployment.specification import Operation
from com.xebialabs.deployit.plugin.api.reflect import Type
from collections import defaultdict

dynamic_cluster_type = "was.DynamicCluster"
extensible_deployed_type = Type.valueOf("was.ExtensibleDeployed")
was_module_type = Type.valueOf("was.Module")


def extract_deployed(delta):
    return delta.deployed if delta.operation != Operation.DESTROY else delta.previous


def is_extensible_deployed_and_dynamic_cluster(delta):
    deployed = extract_deployed(delta)
    return str(deployed.container.type) == dynamic_cluster_type and deployed.type.isSubTypeOf(extensible_deployed_type)


def find_deltas_targeted_to_dynamic_cluster(deltas):
    return [d for d in deltas.deltas if is_extensible_deployed_and_dynamic_cluster(d)]


def add_sync_moment(order, dynamic_cluster, sync_moments):
    if order >= 0:
        sync_moments[order].add(dynamic_cluster)


def define_sync_moments(dynamic_cluster_deltas):
    sync_moments = defaultdict(set)
    for delta in dynamic_cluster_deltas:
        deployed = extract_deployed(delta)
        if delta.operation == Operation.CREATE:
            add_sync_moment(deployed.syncAfterCreateOrder,
                            deployed.container, sync_moments)
        elif delta.operation == Operation.MODIFY:
            if deployed.type.isSubTypeOf(was_module_type) and deployed.isEdition:
                add_sync_moment(deployed.createEditionedOrder + 1,
                                deployed.container, sync_moments)
                add_sync_moment(delta.previous.syncAfterDestroyOrder,
                                deployed.container, sync_moments)
            elif deployed.modifyScript:
                add_sync_moment(deployed.syncAfterModifyOrder,
                                deployed.container, sync_moments)
            else:
                add_sync_moment(delta.deployed.syncAfterCreateOrder,
                                deployed.container, sync_moments)
                add_sync_moment(delta.previous.syncAfterDestroyOrder,
                                deployed.container, sync_moments)
        elif delta.operation == Operation.DESTROY:
            add_sync_moment(deployed.syncAfterDestroyOrder,
                            deployed.container, sync_moments)
    return sync_moments


def add_steps(sync_moments):
    for order, containers in sync_moments.items():
        for container in containers:
            step = steps.wsadmin(description="Synchronize nodes for dynamic cluster %s." % container.name,
                                 order=order, script="was/dynamic_cluster/sync.py", target_cell=container.cell,
                                 python_context={"membership_policy": container.membershipPolicy})
            context.addStep(step)

dynamic_cluster_deltas = find_deltas_targeted_to_dynamic_cluster(deltas)

if len(dynamic_cluster_deltas):
    sync_moments = define_sync_moments(dynamic_cluster_deltas)
    add_steps(sync_moments)
