#
from com.ibm.ws.scripting import ScriptingException

def applicationEdition():
    if deployed.isEdition:
        if deployed.appEdition and len(deployed.appEdition.strip()) > 0:
            return deployed.appEdition
        else:
            printErrorAndExit("Application Edition must be specified when Application is editioned.")
    printErrorAndExit("Application is not editioned");

def getEditionState():
    if(deployed.container.wasTargetType == 'server'):
        wasHome = deployed.container.node.cell.wasHome
    else:
        wasHome = deployed.container.cell.wasHome
    propertiesFile = "%s/config/cells/%s/applications/%s.ear/ibm-edition-metadata.props" % (wasHome, deployed.container.cellName, deployed.name)
    properties = open(propertiesFile, 'r').read().splitlines()
    editionStateProp = [l for l in properties if l.startswith("config.state-edition%s=" % (deployed.appEdition))]
    return editionStateProp[0][len("config.state-edition%s=" % (deployed.appEdition)):].strip()

def rolloutEdition(installArgs):
    editionState = getEditionState()
    print "Current edition state [%s]" % editionState
    if editionState != 'ACTIVE':
        print "Invoking AdminTask rollout edition to activate edition."
        result = AdminTask.rolloutEdition(installArgs)
        if result == "false":
            printErrorAndExit("WebSphere failed to rollout edition. See WebSphere logs for more details.")
    else:
        print "Edition already active, will not invoke AdminTask rollout edition."

def createParamList():
    params = "{rolloutStrategy %s}{resetStrategy %s}{drainageInterval %s}" % (deployed.rolloutStrategy.lower(), deployed.resetStrategy.lower(), str(deployed.drainageInterval))
    if deployed.rolloutStrategy == 'GROUPED':
        params = params + "{groupSize %s}" % (str(deployed.groupSize))
    return ['-appName', deployed.name, '-edition', applicationEdition(), '-params', params]

installArgs = createParamList()
print "Arguments that will be used for rollout:\n %s" % (installArgs)
# Wait for application to be rolled out
count = 0
while count < 2:
    try:
        rolloutEdition(installArgs)
        print "Rollout complete."
        break
    except ScriptingException, e:
        if (e.message.find("msg=Read timed out") != -1) and (count < 2):
            count = count + 1
            print "\nApplication rollout failed with a read timeout, will retry in 5 seconds."
            time.sleep(5)
        else:
            raise e
