import sys
from types import *

def createCluster(clusterName, serverType):
    args = ['-clusterConfig']
    clusterConfigArgs = ['-clusterName', clusterName]
    print "cluster type: %s" % serverType
    clusterConfigArgs.extend(['-clusterType', serverType])
    args.append(clusterConfigArgs)
    print "Creating cluster '%s' with arguments: %s" % (clusterName, listToAdminTaskArgs(args))
    AdminTask.createCluster(listToAdminTaskArgs(args))

def createMembers(clusterName, serverList):
    for server in serverList:
        nodeName = server.split('/')[0]
        serverName = server.split('/')[1]
        serverArgs = ['-clusterName', clusterName, '-memberConfig', ['-memberNode', nodeName, '-memberName', serverName]]
        print "Creating member server '%s' in cluster '%s' with arguments: %s" % (server, clusterName, serverArgs)
        AdminTask.createClusterMember(serverArgs)

def syncServers(servers):
    nodeNames = {}
    for server in servers:
        nodeNames[server.nodeName] = server.nodeName

    for nodeName in nodeNames.keys():
        syncNode(nodeName, full='true')

def checkIfClusterExists(clusterName):
    cluster = AdminConfig.getid('/ServerCluster:%s/' % (clusterName))
    if cluster != "":
        print "WARN: Cluster '%s' already exists. Doing nothing." % (clusterName)
        sys.exit(0)

try:
    cluster = container

except NameError:
    cluster = deployed

checkIfClusterExists(cluster.name)
createCluster(cluster.name, cluster.serverType)
createMembers(cluster.name, cluster.serverList)

saveConfiguration()
syncServers(cluster.servers)

