/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.deployed;

import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedHelper;
import com.xebialabs.deployit.plugin.was.util.ContainerRestartStrategy;
import com.xebialabs.deployit.plugin.was.util.DeployedRestartStrategy;

@Metadata(description="Base class for all extensible deployed configuration items.")
public abstract class ExtensibleDeployed<D extends Deployable, C extends WasContainer>
extends PythonManagedDeployed<D, C> {
    @Property(hidden=true, required=false, description="Python script invoked to deploy a Java EE artifact or create a Java EE resource")
    private String createScript;
    @Property(hidden=true, defaultValue="Create", description="The word that is used to prefix a step description for the create operation.")
    private String createVerb;
    @Property(hidden=true, defaultValue="60", description="The order in which a create step will be executed.")
    private int createOrder;
    @Property(hidden=true, defaultValue="65", description="The order in which a synchronize after create step will be executed.")
    private int syncAfterCreateOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade a Java EE artifact or modify a Java EE resource")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Modify", description="The word that is used to prefix a step description for the modify operation.")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60", description="The order in which a modify step will be executed.")
    private int modifyOrder;
    @Property(hidden=true, defaultValue="65", description="The order in which a synchronize after modify step will be executed.")
    private int syncAfterModifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to undeploy a Java EE artifact or destroy a Java EE resource")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Destroy", description="The word that is used to prefix a step description for the destroy operation.")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="40", description="The order in which a destroy step will be executed.")
    private int destroyOrder;
    @Property(required=false, hidden=true, description="Python script invoked for the noop operation.")
    private String noopScript;
    @Property(hidden=true, defaultValue="Noop")
    private String noopVerb;
    @Property(hidden=true, defaultValue="50", description="The order of the step in the step list for the noop operation.")
    private int noopOrder;
    @Property(hidden=true, defaultValue="45", description="The order in which a synchronize after destroy step will be executed.")
    private int syncAfterDestroyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to start a Java EE artifact or Java EE resource")
    private String startScript;
    @Property(hidden=true, defaultValue="Start", description="The word that is used to prefix a step description for the start operation.")
    private String startVerb;
    @Property(hidden=true, defaultValue="50", description="The order in which a start step will be executed.")
    private int startOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop a Java EE artifact or Java EE resource")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop", description="The word that is used to prefix a step description for the stop operation.")
    private String stopVerb;
    @Property(hidden=true, defaultValue="50", description="The order in which a stop step will be executed.")
    private int stopOrder;
    @Property(defaultValue="STOP_START", hidden=true, category="Restart Strategy", description="The restart strategy for the deployed. STOP_START : stop, undeploy, deploy, start. STOP: stop, undeploy, deploy. START: undeploy, deploy, start.")
    private DeployedRestartStrategy restartStrategy = DeployedRestartStrategy.STOP_START;
    @Property(defaultValue="NONE", hidden=true, category="Restart Strategy", description="The restart strategy for the container affected by the deployed. STOP_START : stop container, undeploy, deploy, start container. RESTART : undeploy, deploy, restart container.")
    private ContainerRestartStrategy containerRestartStrategy = ContainerRestartStrategy.NONE;
    @Property(defaultValue="false", required=false, hidden=true, category="Restart Strategy", description="When true, the restart strategy is apply for a NOOP operation")
    private boolean applyRestartStrategyOnNoop;
    @Property(hidden=true, defaultValue="id, type, properties, deployable, container, createOrder, createScript, createVerb, syncAfterCreateOrder, modifyOrder, modifyScript, modifyVerb, noopOrder, noopScript, noopVerb, syncAfterModifyOrder, destroyOrder, destroyScript, securityPermissions, inheritPermissions, exposeDeployedApplication, destroyVerb, syncAfterDestroyOrder, startOrder, startScript, startVerb, stopOrder, stopScript, stopVerb, discoverScript, inspectScript, discoverOrder, libraryScripts, retryAttemptsForAppReadyCheck, restartStrategy, containerRestartStrategy,applyRestartStrategyOnNoop, provisioners, ordinal, boundConfigurationItems", description="Standard properties that are not exposed to any python wsadmin script.")
    private String standardPropertiesNotToExpose;

    @Create
    public void create(DeploymentPlanningContext ctx, Delta delta) {
        this.create(ctx, delta, ExtensibleDeployed.checkpoint((Delta)delta, (Operation)Operation.CREATE));
    }

    public void create(DeploymentPlanningContext ctx, Delta delta, PythonManagedDeployed.CheckpointInfo checkpoint) {
        this.addStep(ctx, this.createOrder, this.createScript, this.createVerb, checkpoint);
        ExtensibleDeployedHelper.syncNodes(ctx, this.syncAfterCreateOrder, (WasContainer)this.getContainer());
        this.addStartStep(ctx);
    }

    protected void addStartStep(DeploymentPlanningContext ctx) {
        if (this.restartStrategy == DeployedRestartStrategy.STOP_START || this.restartStrategy == DeployedRestartStrategy.START) {
            this.addStep(ctx, this.startOrder, this.startScript, this.startVerb, false);
        }
    }

    protected void addStopStep(DeploymentPlanningContext ctx) {
        if (this.restartStrategy == DeployedRestartStrategy.STOP_START || this.restartStrategy == DeployedRestartStrategy.STOP) {
            this.addStep(ctx, this.stopOrder, this.stopScript, this.stopVerb, false);
        }
    }

    @Modify
    public void modify(DeploymentPlanningContext ctx, Delta delta) {
        this.modify(ctx, delta, ExtensibleDeployed.checkpoint((Delta)delta, (Operation)Operation.MODIFY));
    }

    public void modify(DeploymentPlanningContext ctx, Delta delta, PythonManagedDeployed.CheckpointInfo checkpoint) {
        if (this.addStep(ctx, this.modifyOrder, this.modifyScript, this.modifyVerb, checkpoint)) {
            this.addStartStep(ctx);
            this.addStopStep(ctx);
            ExtensibleDeployedHelper.syncNodes(ctx, this.syncAfterModifyOrder, (WasContainer)this.getContainer());
        } else {
            ExtensibleDeployed previous = (ExtensibleDeployed)delta.getPrevious();
            ExtensibleDeployed current = (ExtensibleDeployed)delta.getDeployed();
            previous.restartStrategy = current.restartStrategy;
            previous.containerRestartStrategy = current.containerRestartStrategy;
            if (checkpoint == null) {
                previous.destroy(ctx, delta, null, true);
                current.create(ctx, delta, null);
            } else {
                previous.destroy(ctx, delta);
                current.create(ctx, delta);
            }
        }
    }

    @Noop
    public void executeNoop(DeploymentPlanningContext ctx, Delta delta) {
        ExtensibleDeployed deployed = (ExtensibleDeployed)delta.getDeployed();
        deployed.addStep(ctx, this.noopOrder, this.noopScript, this.noopVerb, false, null);
        if (this.applyRestartStrategyOnNoop) {
            this.addStartStep(ctx);
            this.addStopStep(ctx);
        }
    }

    @Destroy
    public void destroy(DeploymentPlanningContext ctx, Delta delta) {
        this.destroy(ctx, delta, ExtensibleDeployed.checkpoint((Delta)delta, (Operation)Operation.DESTROY), true);
    }

    public void destroy(DeploymentPlanningContext ctx, Delta delta, PythonManagedDeployed.CheckpointInfo checkpoint, boolean isStopStepRequired) {
        if (isStopStepRequired) {
            this.addStopStep(ctx);
        }
        this.addStep(ctx, this.destroyOrder, this.destroyScript, this.destroyVerb, false, checkpoint);
        ExtensibleDeployedHelper.syncNodes(ctx, this.syncAfterDestroyOrder, (WasContainer)this.getContainer());
    }

    public String getCreateScript() {
        return this.createScript;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public int getCreateOrder() {
        return this.createOrder;
    }

    public String getModifyScript() {
        return this.modifyScript;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public int getModifyOrder() {
        return this.modifyOrder;
    }

    public int getSyncAfterModifyOrder() {
        return this.syncAfterModifyOrder;
    }

    public String getDestroyScript() {
        return this.destroyScript;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public int getDestroyOrder() {
        return this.destroyOrder;
    }

    public int getSyncAfterDestroyOrder() {
        return this.syncAfterDestroyOrder;
    }

    public String getStartScript() {
        return this.startScript;
    }

    public String getStartVerb() {
        return this.startVerb;
    }

    public int getStartOrder() {
        return this.startOrder;
    }

    public String getStopScript() {
        return this.stopScript;
    }

    public String getStopVerb() {
        return this.stopVerb;
    }

    public int getStopOrder() {
        return this.stopOrder;
    }

    public String getStandardPropertiesNotToExpose() {
        return this.standardPropertiesNotToExpose;
    }

    public int getSyncAfterCreateOrder() {
        return this.syncAfterCreateOrder;
    }

    protected DeployedRestartStrategy getRestartStrategy() {
        return this.restartStrategy;
    }

    protected void setRestartStrategy(DeployedRestartStrategy restartStrategy) {
        this.restartStrategy = restartStrategy;
    }

    protected ContainerRestartStrategy getContainerRestartStrategy() {
        return this.containerRestartStrategy;
    }

    protected void setContainerRestartStrategy(ContainerRestartStrategy containerRestartStrategy) {
        this.containerRestartStrategy = containerRestartStrategy;
    }
}

