/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.BaseCluster;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import java.util.Set;

@Metadata(description="A WebSphere Application Server deployment manager (WAS ND)", inspectable=true)
public class DeploymentManager
extends BaseCell {
    @Property(description="WebSphere nodes in the cell", asContainment=true, required=false)
    private Set<NodeAgent> nodeAgents = Sets.newHashSet();
    @Property(description="WebSphere clusters in the cell", asContainment=true, required=false)
    private Set<BaseCluster> clusters = Sets.newHashSet();

    @Override
    public String getCellName() {
        return this.getName();
    }

    @Override
    public Set<? extends Node> getNodes() {
        return this.nodeAgents;
    }

    public void addNode(NodeAgent node) {
        this.nodeAgents.add(node);
    }

    public Set<BaseCluster> getClusters() {
        return this.clusters;
    }

    public void addCluster(BaseCluster cluster) {
        this.clusters.add(cluster);
    }

    @Override
    public String getContainmentPath() {
        return "/Cell:" + this.getName();
    }

    @Override
    public String getWasConfigIdType() {
        return "Cell";
    }

    @Override
    public String getWasTargetType() {
        return "Cell";
    }

    @Override
    public String getShortTypeDescription() {
        return "cell";
    }
}

