import sys
from types import *

def createCluster(clusterName, serverType):
    args = ['-clusterConfig']
    clusterConfigArgs = ['-clusterName', clusterName]
    print "cluster type: %s" % serverType
    clusterConfigArgs.extend(['-clusterType', serverType])
    args.append(clusterConfigArgs)
    print "Creating cluster '%s' with arguments: %s" % (clusterName, listToAdminTaskArgs(args))
    AdminTask.createCluster(listToAdminTaskArgs(args))

def createMembers(clusterName, servers, template):
    firstMember = True

    for server in servers:
        nodeName = server.nodeName
        serverName = server.name
        serverArgs = ['-clusterName', clusterName, '-memberConfig', ['-memberNode', nodeName, '-memberName', serverName]]
        if template is not None and template != '':
                if firstMember:
                  serverArgs.append('-firstMember')
                  serverArgs.append(['-templateName', template])
                  firstMember = False
                else:
                  print "WARN: Ignoring template '%s' since '%s' is not the first member of the cluster" % (template, server.name)
        print "Creating member server '%s' in cluster '%s' with arguments: %s" % (serverName, clusterName, serverArgs)
        AdminTask.createClusterMember(serverArgs)

def syncServers(servers):
    nodeNames = {}
    for server in servers:
        nodeNames[server.nodeName] = server.nodeName

    for nodeName in nodeNames.keys():
        syncNode(nodeName, full='true')

def checkIfClusterExists(clusterName):
    cluster = AdminConfig.getid('/ServerCluster:%s/' % (clusterName))
    if cluster != "":
        print "WARN: Cluster '%s' already exists. Doing nothing." % (clusterName)
        sys.exit(0)

try:
    cluster = container

except NameError:
    cluster = deployed

template = parameters.template

checkIfClusterExists(cluster.name)
createCluster(cluster.name, cluster.serverType)
createMembers(cluster.name, cluster.servers, template)

saveConfiguration()
syncServers(cluster.servers)
