def discoverAndInspectSSLConfigInContainer():
    securityId = AdminConfig.getid("/Cell:%s/Security:/" % (container.cellName))
    keyStoreList = wsadminToList(AdminConfig.list('KeyStore', securityId))
    for keyStore in keyStoreList:
        deployedName = AdminConfig.showAttribute(keyStore, 'name')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectDeployedProperties(deployedId, deployedName, keyStore, prototype)
        inspectedProperty(deployedId, 'keyStoreType', AdminConfig.showAttribute(keyStore, 'type'))
        inspectedProperty(deployedId, 'location', AdminConfig.showAttribute(keyStore, 'location'))
        if getVersion(container) != 'WAS_61':
            inspectedProperty(deployedId, 'description', AdminConfig.showAttribute(keyStore, 'description'))
        inspectNestedProperties(deployedId, deployedName, keyStore, "managementScope")
        inspectedItem(deployedId)

discoverAndInspectSSLConfigInContainer()