$shareName = if($deployed.shareName) { $deployed.shareName } else { $deployed.name }

Write-Output "Creating share [$shareName] to [$($deployed.targetPath)]"
$Shares = [WMICLASS]"WIN32_Share"
$res = $Shares.Create($deployed.targetPath, $shareName, 0)

if ($res.ReturnValue -ne 0) {
    Write-Output "Cannot create share [$shareName] (error code $($res.ReturnValue))"
    exit $res.ReturnValue
}
