#
class Struct(dict):
    """
    """
    def __init__(self, *args, **kw):
        super(Struct, self).__init__(*args, **kw)

    def __getattr__(self, name):
        if name in self:
            return self[name]
        else:
            super(Struct, self).__getattr__(name)

    def __setattr__(self, name, value):
        self[name] = value

    def __delattr__(self, name):
        del self[name]

    ## overrides to ensure repetable ordering
    def __iter__(self):
        for key in sorted(super(Struct, self).iterkeys()):
            yield key

    def keys(self):
        return list(self.iterkeys())

    def values(self):
        return [self[key] for key in self]

    def items(self):
        return [(key, self[key]) for key in self]

    def iterkeys(self):
        return iter(self)

    def itervalues(self):
        for k in self:
            yield self[k]

    def iteritems(self):
        for k in self:
            yield (k, self[k])