#
from com.xebialabs.overthere.util import OverthereUtils
from wlp.modules.utility import Logger

class OverthereHostSession(object):
    """
    """
    def __init__(self, host):
        self._host = host
        self._conn = None

    def __enter__(self):
        return self

    def __exit__(self, type, value, traceback):
        self.close_conn()

    def get_conn(self):
        if self._conn is None:
            self._conn = self._host.connection
        return self._conn

    def close_conn(self):
        if self._conn is not None:
            self._conn.close()
            self._conn = None

    def remote_file(self, filepath):
        return self.get_conn().getFile(filepath)

    def read_file(self, filepath, encoding="UTF-8"):
        otfile = self.get_conn().getFile(filepath)
        if not otfile.exists():
            Logger.log_and_raise_error("File [%s] does not exist" % filepath)
        return OverthereUtils.read(otfile, encoding)

    def write_file(self, content, filepath, mkdirs=True):
        otfile = self.get_conn().getFile(filepath)
        parent = otfile.parentFile
        if mkdirs and not parent.exists():
            print "Creating path %s" % parent.path
            parent.mkdirs()
        OverthereUtils.write(str(content), otfile)