from __future__ import with_statement
from wlp.modules.overthere import OverthereHostSession
from wlp.modules.configuration import Configuration
from wlp.modules.utility import Paths

with OverthereHostSession(previousDeployed.container.host) as session:
    print "Removing feature '%s' from container '%s'" % (previousDeployed.name, previousDeployed.container.name)
    server_xml_path = Paths.get_server_xml_path(previousDeployed)
    configuration = Configuration(session.read_file(server_xml_path))
    configuration.remove_feature(previousDeployed)
    session.write_file(configuration.to_string(), server_xml_path)
    print "Feature '%s' successfully removed" % previousDeployed.name
