#
from wlp.modules.utility import Paths
from com.xebialabs.deployit.plugin.api.deployment.specification import Operation
from com.xebialabs.deployit.plugin.api.deployment.planning import DefaultOrders

context.addStepWithCheckpoint(steps.jython(
    description="Remove '%s' application entry from server '%s'" % (previousDeployed.name, previousDeployed.container.name),
    script="wlp/scripts/resource/destroy-resource.py",
    order=DefaultOrders.UNDEPLOY_ARTIFACTS
), delta, Operation.DESTROY)
context.addStepWithCheckpoint(steps.delete(
    description="Delete application '%s' from server '%s'" % (previousDeployed.name, previousDeployed.container.name),
    target_path=Paths.get_target_path(previousDeployed),
    order=DefaultOrders.UNDEPLOY_ARTIFACTS + 1
), delta, Operation.DESTROY)
if previousDeployed.restartStrategy == "STOP_START" or (delta.operation == 'MODIFY' and deployed.restartStrategy == "STOP_START"):
    context.addStep(steps.jython(
        description="Stop application '%s' on server '%s'" % (previousDeployed.name, previousDeployed.container.name),
        order=DefaultOrders.STOP_ARTIFACTS,
        script="wlp/scripts/application/stop-application.py",
        jython_context={"thisCi": previousDeployed}
    ))