#
import urllib
from wlp.modules.mbean.connector import JMXSSLConnector, MethodCall


class FileNotificationMBean(object):
    def __init__(self, container):
        self.connector = JMXSSLConnector(container)

    def reload_server_configuration(self):
        method_call = MethodCall().with_signature(["java.util.Collection"] * 3) \
            .with_array_param([], "java.util.ArrayList") \
            .with_array_param(["server.xml"], "java.util.ArrayList", "java.lang.String") \
            .with_array_param([], "java.util.ArrayList") \
            .build()
        self.connector.send("POST", self._mbean_url("notifyFileChanges"), method_call)

    @staticmethod
    def _mbean_url(operation):
        return urllib.quote("/IBMJMXConnectorREST/mbeans/WebSphere:service=com.ibm.ws.kernel.filemonitor.FileNotificationMBean/operations/%s" % operation)