/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.deployed;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.DeployedSpecific;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wls.DeploymentMode;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.container.Cluster;
import com.xebialabs.deployit.plugin.wls.container.Server;
import com.xebialabs.deployit.plugin.wls.container.StageMode;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.contributor.ArtifactDeploymentContributor;
import com.xebialabs.deployit.plugin.wls.contributor.MultiTargetArtifactDeploymentContributor;
import com.xebialabs.deployit.plugin.wls.deployed.BaseWlsDeployed;
import com.xebialabs.deployit.plugin.wls.step.DeleteArtifactStep;
import com.xebialabs.deployit.plugin.wls.step.UploadArtifactStep;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(virtual=true, description="Base class for all deployeds meant to contain Applications")
@Placeholders
public class ExtensibleDeployedArtifact<D extends DeployableArtifact>
extends BaseWlsDeployed<D, WlsContainer>
implements DerivedArtifact<DeployableArtifact> {
    protected static final Logger logger = LoggerFactory.getLogger(ExtensibleDeployedArtifact.class);
    public static final Type DEPLOYED_SHARED_LIB_WAR = Type.valueOf((String)"wls", (String)"SharedLibraryWarModule");
    public static final String VAR_USE_RETIRE_TIMEOUT = "useRetireTimeout";
    public static final String VAR_TARGETS = "targets";
    public static final int NO_RETIREMENT_TIMEOUT = -1;
    @Property(defaultValue="Stage", required=false, label="Staging mode", description="Indicates whether the artifact will be deployed as staged or nostage mode")
    private StageMode stageMode;
    @Property(required=false, label="Staging directory", description="Absolute directory path where the artifact will be uploaded and used by the servers for nostage deployment mode")
    private String stagingDirectory;
    @Property(required=true, defaultValue="CLASSIC", label="Redeployment strategy", description="Indicates what redeployment strategy to use for upgrading the application. Possible values: CLASSIC, STOP_START, SIDE_BY_SIDE")
    private DeploymentStrategy redeploymentStrategy;
    @Property(required=false, description="Indicates wither this artifact is to be deployed as a versioned application", category="Versioning")
    private boolean versioned = false;
    @Property(required=false, defaultValue="-1", label="Retire timeout", description="Timeout interval (in secs) before the previous application version is undeployed for side by side redeployment strategy", category="Versioning")
    private int retireTimeout;
    @Property(required=false, category="Versioning")
    private String versionIdentifier;
    @Property(required=false, defaultValue="true", category="Versioning", label="Automatic versioning", description="If set, the 'versionIdentifier' property is managed by the plugin. Any value explicitly set for 'versionIdentifier' is ignored. 'automaticVersioning' is enabled by default, in which case a unique version is created for the deployed module. If the manifest file includes an implementation version, then you must disable 'automaticVersioning'. If your manifest file includes a specification version and you want to use the implementation version that is defined in the manifest file, then you must set 'automaticVersioning' to false and enter the specification version as the 'versionIdentifier' property on the CI.")
    private boolean automaticVersioning;
    @Property(hidden=true, defaultValue="id, name, type, deployable, properties, container, createScript, createVerb, createOrder, modifyScript, modifyVerb, modifyOrder, destroyScript, destroyVerb, destroyOrder, deleteArtifactOrder,  startScript, startVerb, startOrder, stopScript, stopVerb, stopOrder, deploymentStrategy, placeholders, file, redeploymentStrategy, securityPermissions, inheritPermissions, exposeDeployedApplication, stopRetiredApplicationOrder, undeployRetiredApplicationOrder, deleteRetiredArtifactOrder, isRunningRetryWaitInterval, wlstPath, libraryScripts, discoverOrder, deploymentOrder, isStartOrStopOperationRequired, automaticVersioning, createOptions, modifyOptions, destroyOptions, noopOptions, manifestVersionProperty, versionTemplateFile, provisioners, ordinal, boundConfigurationItems")
    private String standardPropertiesNotToExpose;
    @Property(category="Placeholders", description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    @DeployedSpecific
    private Map<String, String> placeholders = Maps.newHashMap();
    @Property(hidden=true, required=false, description="Python script invoked to deploy this Java EE artifact")
    private String createScript;
    @Property(hidden=true, defaultValue="Deploy")
    private String createVerb;
    @Property(hidden=true, defaultValue="70")
    private int createOrder;
    @Property(hidden=true, required=false, description="Python script invoked to upgrade this Java EE artifact")
    private String modifyScript;
    @Property(hidden=true, defaultValue="Upgrade")
    private String modifyVerb;
    @Property(hidden=true, defaultValue="60")
    private int modifyOrder;
    @Property(hidden=true, required=false, description="Python script invoked to undeploy this Java EE artifact")
    private String destroyScript;
    @Property(hidden=true, defaultValue="Undeploy")
    private String destroyVerb;
    @Property(hidden=true, defaultValue="30")
    private int destroyOrder;
    @Property(hidden=true, defaultValue="31")
    private int deleteArtifactOrder;
    @Property(hidden=true, defaultValue="58")
    private int undeployRetiredApplicationOrder;
    @Property(hidden=true, defaultValue="55")
    private int stopRetiredApplicationOrder;
    @Property(hidden=true, defaultValue="99")
    private int deleteRetiredArtifactOrder;
    @Property(hidden=true, required=false, description="Python script invoked to start this Java EE artifact")
    private String startScript;
    @Property(hidden=true, defaultValue="Start")
    private String startVerb;
    @Property(hidden=true, defaultValue="90")
    private int startOrder;
    @Property(hidden=true, required=false, description="Python script invoked to stop this Java EE artifact")
    private String stopScript;
    @Property(hidden=true, defaultValue="Stop")
    private String stopVerb;
    @Property(hidden=true, defaultValue="10")
    private int stopOrder;
    @Property(hidden=true, defaultValue="true", required=false)
    private boolean isStartOrStopOperationRequired;
    private OverthereFile derivedFile;
    private Map<String, Object> pythonVars = Maps.newHashMap();

    @Create
    public void deployArtifact(DeploymentPlanningContext result, Delta delta) {
        this.validateDeployedFields();
        this.handleCopyArtifact(result);
        this.addStepWithCheckpoint(result, delta, Operation.CREATE, this.createOrder, this.createScript, this.createVerb, this.createOptions);
    }

    @Modify
    public void modifyArtifact(DeploymentPlanningContext result, Delta delta) {
        if (!Strings.isNullOrEmpty((String)this.modifyScript)) {
            this.addStepWithCheckpoint(result, delta, Operation.MODIFY, this.modifyOrder, this.modifyScript, this.modifyVerb, this.modifyOptions);
        } else {
            ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact)delta.getPrevious();
            ExtensibleDeployedArtifact current = (ExtensibleDeployedArtifact)delta.getDeployed();
            this.validateModifiedDeployed(previous, current);
            previous.destroyArtifact(result, delta);
            current.deployArtifact(result, delta);
        }
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE && this.getRetireTimeout() != -1) {
            this.pythonVars.put(VAR_USE_RETIRE_TIMEOUT, true);
            ArtifactDeploymentContributor.setWaitStepInterval(result, this.getRetireTimeout());
        }
    }

    @Destroy
    public void destroyArtifact(DeploymentPlanningContext result, Delta delta) {
        ExtensibleDeployedArtifact currentDeployed;
        int undeployOrder = this.destroyOrder;
        int deleteOrder = this.deleteArtifactOrder;
        if (delta.getOperation() == Operation.MODIFY && (currentDeployed = (ExtensibleDeployedArtifact)delta.getDeployed()).getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            if (currentDeployed.getRetireTimeout() == -1) {
                return;
            }
            undeployOrder = this.undeployRetiredApplicationOrder;
            deleteOrder = this.deleteRetiredArtifactOrder;
        }
        this.addStepWithCheckpoint(result, delta, Operation.DESTROY, undeployOrder, this.destroyScript, this.destroyVerb, this.withoutUpload(this.destroyOptions));
        this.handleDeleteArtifact(result, deleteOrder);
    }

    private boolean isStartOrStopOperationRequired() {
        if (this.isStartOrStopOperationRequired && this.getRedeploymentStrategy() == DeploymentStrategy.STOP_START) {
            return false;
        }
        return this.isStartOrStopOperationRequired;
    }

    @Create
    @Modify
    public void startApplication(DeploymentPlanningContext result, Delta delta) {
        if (this.isStartOrStopOperationRequired()) {
            Set<String> options = this.withoutUpload(delta.getOperation() == Operation.CREATE ? this.createOptions : this.modifyOptions);
            this.addStep(result, delta, this.startOrder, this.startScript, this.startVerb, options);
        }
    }

    @Modify
    public void stopApplicationForModifedArtifact(DeploymentPlanningContext result, Delta delta) {
        if (!this.isStartOrStopOperationRequired()) {
            return;
        }
        ExtensibleDeployedArtifact previous = (ExtensibleDeployedArtifact)delta.getPrevious();
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE) {
            if (this.getRetireTimeout() == -1) {
                return;
            }
            previous.addStep(result, delta, this.stopRetiredApplicationOrder, this.stopScript, this.stopVerb, this.withoutUpload(this.modifyOptions));
        } else {
            previous.addStep(result, delta, this.stopOrder, this.stopScript, this.stopVerb, this.withoutUpload(this.modifyOptions));
        }
    }

    @Destroy
    public void stopApplication(DeploymentPlanningContext result, Delta delta) {
        if (this.isStartOrStopOperationRequired()) {
            this.addStep(result, delta, this.stopOrder, this.stopScript, this.stopVerb, this.withoutUpload(this.destroyOptions));
        }
    }

    @Override
    protected boolean addStep(DeploymentPlanningContext ctx, Delta delta, Operation operation, int order, String scriptPath, String verb, Set<String> options) {
        if (this.isMultiTargetDeployment()) {
            logger.debug("postpone step {} {} : {} for multi-target postprocessing", new Object[]{verb, ((DeployableArtifact)this.getDeployable()).getFile().getName(), order});
            MultiTargetArtifactDeploymentContributor.storeDeploymentStep(ctx, this, order, scriptPath, verb, options, delta);
            return true;
        }
        return super.addStep(ctx, delta, operation, order, scriptPath, verb, options);
    }

    protected boolean isMultiTargetDeployment() {
        Container container = this.getContainer();
        boolean containerIsServer = container instanceof Server;
        boolean containerIsCluster = container instanceof Cluster;
        boolean validMultiTargetContainer = containerIsServer || containerIsCluster;
        boolean deploymentModeIsMultiTarget = ((WlsContainer)this.getContainer()).getDomain().getDeploymentMode() == DeploymentMode.MULTI_TARGET;
        return deploymentModeIsMultiTarget && validMultiTargetContainer;
    }

    protected Set<String> withoutUpload(Set<String> options) {
        return Sets.filter(options, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !"uploadArtifactData".equals(input);
            }
        });
    }

    protected String getDescription(String verb) {
        if (Artifact.class.isAssignableFrom(((DeployableArtifact)this.getDeployable()).getClass())) {
            return String.format("%s %s (%s) on %s", verb, this.getName(), ((DeployableArtifact)this.getDeployable()).getFile().getName(), ((WlsContainer)this.getContainer()).getName());
        }
        return super.getDescription(verb);
    }

    @Override
    public Map<String, Object> getPythonVars(Deployed<?, ?> previous, DeployedApplication deployedApplication, Set<String> options) {
        this.pythonVars.putAll(super.getPythonVars(previous, deployedApplication, options));
        this.pythonVars.put(VAR_TARGETS, ((WlsContainer)this.getContainer()).getName());
        if (!this.pythonVars.containsKey(VAR_USE_RETIRE_TIMEOUT)) {
            this.pythonVars.put(VAR_USE_RETIRE_TIMEOUT, false);
        }
        return this.pythonVars;
    }

    private void validateModifiedDeployed(ExtensibleDeployedArtifact<DeployableArtifact> previous, ExtensibleDeployedArtifact<DeployableArtifact> current) {
        this.validateDeployedFields();
        if (this.isNoStageMode()) {
            String previousStagingDir = previous.getStagingDirectory();
            String currentStagingDir = current.getStagingDirectory();
            if (previousStagingDir != null && previousStagingDir.equals(currentStagingDir)) {
                throw new RuntimeException("Can't deploy a new version to " + currentStagingDir + ". This is same as the previous deployment nostage directory!");
            }
        }
    }

    private void validateDeployedFields() {
        if (this.isNoStageMode()) {
            if (Strings.isNullOrEmpty((String)this.getStagingDirectory())) {
                throw new RuntimeException("Staging directory shouldn't be blank");
            }
            if (((WlsContainer)this.getContainer()).getHosts() == null) {
                throw new RuntimeException("NoStage deployment: the target " + this.getContainer() + " contains no hosts, check your repository");
            }
        }
        if (this.getRedeploymentStrategy() == DeploymentStrategy.SIDE_BY_SIDE && !this.isVersioned()) {
            throw new RuntimeException("SIDE_BY_SIDE deployment strategy is only applicable for versioned deployment");
        }
        if (this.getRedeploymentStrategy() != DeploymentStrategy.SIDE_BY_SIDE && this.getRetireTimeout() != -1) {
            throw new RuntimeException("Retirement timeout is only applicable for SIDE_BY_SIDE deployment strategy.");
        }
    }

    protected void handleCopyArtifact(DeploymentPlanningContext result) {
        if (this.isNoStageMode()) {
            HashSet<Host> hosts = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            Host domainHost = ((WlsContainer)this.getContainer()).getDomain().getHost();
            hosts.add(domainHost);
            String remoteDestinationFilename = this.getRemoteDestinationFilename(domainHost);
            for (Host h : hosts) {
                ArtifactDeploymentContributor.addUploadArtifactStep(result, new UploadArtifactStep(68, h, (Artifact)this.getDeployable(), this.getRemoteDestinationFilename(h), domainHost));
            }
            this.pythonVars.put("remoteDestinationFilename", remoteDestinationFilename);
        }
    }

    protected void handleDeleteArtifact(DeploymentPlanningContext result, int order) {
        if (this.isNoStageMode()) {
            HashSet<Host> hosts = new HashSet<Host>(((WlsContainer)this.getContainer()).getHosts());
            Host domainHost = ((WlsContainer)this.getContainer()).getDomain().getHost();
            hosts.add(domainHost);
            for (Host h : hosts) {
                ArtifactDeploymentContributor.addDeleteArtifactStep(result, new DeleteArtifactStep(order, h, this.getRemoteDestinationFilename(h), domainHost));
            }
        }
    }

    private String getRemoteDestinationFilename(Host host) {
        return this.getStagingDirectory() + host.getOs().getFileSeparator() + ((DeployableArtifact)this.getDeployable()).getFile().getName();
    }

    private boolean isNoStageMode() {
        return this.getStageMode().equals((Object)StageMode.NoStage);
    }

    public StageMode getStageMode() {
        return this.stageMode;
    }

    public void setStageMode(StageMode stageMode) {
        this.stageMode = stageMode;
    }

    public String getStagingDirectory() {
        return this.stagingDirectory;
    }

    public void setStagingDirectory(String stagingDirectory) {
        this.stagingDirectory = stagingDirectory;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public void setVersioned(boolean versioned) {
        this.versioned = versioned;
    }

    public boolean isAutomaticVersioning() {
        return this.automaticVersioning;
    }

    public void setAutomaticVersioning(boolean automaticVersioning) {
        this.automaticVersioning = automaticVersioning;
    }

    public DeploymentStrategy getRedeploymentStrategy() {
        return this.redeploymentStrategy;
    }

    public void setRedeploymentStrategy(DeploymentStrategy deploymentStrategy) {
        this.redeploymentStrategy = deploymentStrategy;
    }

    public int getRetireTimeout() {
        return this.retireTimeout;
    }

    public void setRetireTimeout(int retireTimeout) {
        this.retireTimeout = retireTimeout;
    }

    public OverthereFile getFile() {
        return this.derivedFile;
    }

    public void setFile(OverthereFile file) {
        this.derivedFile = file;
    }

    public DeployableArtifact getSourceArtifact() {
        return (DeployableArtifact)this.getDeployable();
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public String getCreateVerb() {
        return this.createVerb;
    }

    public String getModifyVerb() {
        return this.modifyVerb;
    }

    public String getDestroyVerb() {
        return this.destroyVerb;
    }

    public String getStartVerb() {
        return this.startVerb;
    }

    public String getStopVerb() {
        return this.stopVerb;
    }
}

