/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.contributor;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.wls.DeploymentStrategy;
import com.xebialabs.deployit.plugin.wls.ResourceTargetRestartPolicy;
import com.xebialabs.deployit.plugin.wls.container.WlsContainer;
import com.xebialabs.deployit.plugin.wls.deployed.CopiedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.deployed.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class WlsContainerStopStartContributor {
    @Contributor
    public static void stopContainers(Deltas deltas, DeploymentPlanningContext result) {
        result.addSteps(Iterables.concat((Iterable)Iterables.transform(WlsContainerStopStartContributor.gatherTargets(deltas.getDeltas()), (Function)new Function<WlsContainer, List<Step>>(){

            public List<Step> apply(WlsContainer container) {
                return container.getStopSteps(container.getStopOrder());
            }
        })));
    }

    @Contributor
    public static void startContainers(Deltas deltas, DeploymentPlanningContext result) {
        result.addSteps(Iterables.concat((Iterable)Iterables.transform(WlsContainerStopStartContributor.gatherTargets(deltas.getDeltas()), (Function)new Function<WlsContainer, List<Step>>(){

            public List<Step> apply(WlsContainer container) {
                return container.getStartSteps(container.getStartOrder());
            }
        })));
    }

    private static Set<WlsContainer> gatherTargets(List<Delta> operations) {
        HashSet wlsTargets = Sets.newHashSet();
        for (Delta operation : operations) {
            WlsContainerStopStartContributor.addTarget(wlsTargets, operation.getOperation(), operation.getDeployed());
            WlsContainerStopStartContributor.addTarget(wlsTargets, operation.getOperation(), operation.getPrevious());
        }
        return wlsTargets;
    }

    private static void addTarget(Set<WlsContainer> wlsTargets, Operation operation, Deployed<?, ?> deployed) {
        ExtensibleDeployedArtifact deployedArtifact;
        DeploymentStrategy deploymentStrategy;
        if (deployed == null) {
            return;
        }
        if (operation == Operation.NOOP) {
            return;
        }
        if (deployed instanceof Resource || deployed instanceof CopiedArtifact) {
            boolean restartTarget = (Boolean)deployed.getProperty("restartTarget");
            ResourceTargetRestartPolicy restartPolicy = (ResourceTargetRestartPolicy)((Object)deployed.getProperty("targetRestartPolicy"));
            if (restartTarget && restartPolicy == ResourceTargetRestartPolicy.STOP_START) {
                wlsTargets.add((WlsContainer)deployed.getContainer());
            }
        } else if (deployed instanceof ExtensibleDeployedArtifact && (deploymentStrategy = (deployedArtifact = (ExtensibleDeployedArtifact)deployed).getRedeploymentStrategy()) == DeploymentStrategy.STOP_START) {
            wlsTargets.add((WlsContainer)deployed.getContainer());
        }
    }
}

