/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;

public class WaitingStep
implements Step {
    private final long waitTime;
    private int order;

    public WaitingStep(int order, long time) {
        if (time < 0L) {
            throw new RuntimeException("negative values invalid (" + time + ")");
        }
        this.waitTime = time;
        this.order = order;
    }

    public String getDescription() {
        return "Wait for " + this.waitTime + " second(s)";
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            Thread.sleep(this.waitTime * 1000L);
        }
        catch (InterruptedException e) {
            ctx.logError("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Done waiting");
        return StepExitCode.SUCCESS;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public int getOrder() {
        return this.order;
    }
}

