/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.preplanprocessor;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.wls.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.wls.freemarker.TemplateEvaluator;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TVFS;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WlsArtifactProcessor {
    private static final Logger logger = LoggerFactory.getLogger(WlsArtifactProcessor.class);
    private static final Function<Delta, ExtensibleDeployedArtifact<?>> TO_DEPLOYED = delta -> {
        Deployed deployed = delta.getDeployed();
        return deployed instanceof ExtensibleDeployedArtifact && delta.getOperation() != Operation.NOOP ? (ExtensibleDeployedArtifact)deployed : null;
    };
    private static final Predicate<ExtensibleDeployedArtifact<?>> IS_VERSIONED = input -> Predicates.notNull().apply((Object)input) && input.isVersioned();

    @PrePlanProcessor
    public static Step setVersionIdentifiers(DeltaSpecification spec) {
        String appVersion = spec.getDeployedApplication().getVersion().getVersion();
        String appName = spec.getDeployedApplication().getVersion().getApplication().getName();
        String defaultVersion = appName + "-" + appVersion;
        VersionSetter version = new VersionSetter(defaultVersion);
        for (ExtensibleDeployedArtifact artifact : Iterables.filter((Iterable)Iterables.transform((Iterable)spec.getDeltas(), TO_DEPLOYED), IS_VERSIONED)) {
            if (!Strings.isNullOrEmpty((String)artifact.getVersionIdentifier()) && !artifact.isAutomaticVersioning()) continue;
            version.apply(artifact);
        }
        return null;
    }

    private static <T> void ignoreException(T value, ConsumerWithException<T> consumer) {
        try {
            if (value != null) {
                consumer.consume(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static interface ConsumerWithException<T> {
        public void consume(T var1) throws Exception;
    }

    private static class VersionSetter
    implements Function<ExtensibleDeployedArtifact<?>, Void> {
        private final String defaultVersion;

        public VersionSetter(String defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public Void apply(ExtensibleDeployedArtifact<?> deployed) {
            Artifact artifact = (Artifact)deployed.getDeployable();
            Manifest manifest = this.readManifest(artifact);
            if (manifest == null) {
                logger.debug("Unable to read manifest for {}", (Object)artifact.getFile().getName());
                return null;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String extName = mainAttributes.getValue((String)deployed.getProperty("manifestVersionProperty"));
            deployed.setVersioned(true);
            if (Strings.isNullOrEmpty((String)extName)) {
                logger.debug("Setting version identifier to default value '{}'", (Object)this.defaultVersion);
                deployed.setVersionIdentifier(this.defaultVersion);
            } else {
                HashMap<String, String> attributesAsMap = new HashMap<String, String>();
                for (Object key : mainAttributes.keySet()) {
                    attributesAsMap.put(key.toString(), mainAttributes.getValue(key.toString()));
                }
                ImmutableMap vars = ImmutableMap.of((Object)"manifestAttributes", attributesAsMap);
                String versionIdentifier = TemplateEvaluator.evaluateExpression((String)deployed.getProperty("versionExpression"), (Map<String, Object>)vars);
                versionIdentifier = versionIdentifier.replace('\n', ' ').replace("\r\n", " ").trim();
                logger.debug("Setting version identifier to manifest-derived values '{}'", (Object)versionIdentifier);
                deployed.setVersionIdentifier(versionIdentifier);
            }
            return null;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Manifest readManifest(Artifact artifact) {
            Manifest manifest;
            TFileInputStream is = null;
            OverthereFile file = artifact.getFile();
            String fileName = file.getName();
            Path tmpPath = null;
            TFile mainTFile = null;
            TFile manifestTFile = null;
            try {
                tmpPath = Files.createTempFile("manifest", fileName, new FileAttribute[0]);
                Files.copy(file.getInputStream(), tmpPath, StandardCopyOption.REPLACE_EXISTING);
                mainTFile = new TFile(tmpPath.toFile());
                manifestTFile = new TFile((File)mainTFile, "META-INF/MANIFEST.MF");
                Preconditions.checkArgument((boolean)manifestTFile.exists(), (String)"The archive [%s] does not contain a MANIFEST.MF file.", (Object)fileName);
                is = new TFileInputStream((File)manifestTFile);
                manifest = new Manifest((InputStream)is);
            }
            catch (FileNotFoundException fnfe) {
                try {
                    throw new RuntimeIOException(String.format("The archive [%s] does not contain a MANIFEST.MF file.", fileName), (Throwable)fnfe);
                    catch (IOException e) {
                        throw new RuntimeIOException(String.format("Error reading the MANIFEST.MF in archive [%s].", fileName), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(is);
                    WlsArtifactProcessor.ignoreException(mainTFile, tfile -> tfile.rm_r());
                    WlsArtifactProcessor.ignoreException(manifestTFile, TVFS::umount);
                    WlsArtifactProcessor.ignoreException(mainTFile, TVFS::umount);
                    throw throwable;
                }
            }
            Closeables.closeQuietly((Closeable)is);
            WlsArtifactProcessor.ignoreException(mainTFile, tfile -> tfile.rm_r());
            WlsArtifactProcessor.ignoreException(manifestTFile, TVFS::umount);
            WlsArtifactProcessor.ignoreException(mainTFile, TVFS::umount);
            return manifest;
        }
    }
}

