/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.wls.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.wls.utils.Closeables;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.io.Closeable;

public class DeleteArtifactStep
implements Step,
SatelliteAware {
    private final int order;
    private final Host host;
    private final String artifactPath;
    private Host domainHost;

    public DeleteArtifactStep(int order, Host host, String artifactPath, Host domainHost) {
        this.order = order;
        this.host = host;
        this.artifactPath = artifactPath;
        this.domainHost = domainHost;
    }

    public String getDescription() {
        return String.format("Delete artifact %s", this.artifactPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        OverthereConnection connection = this.host.getConnection();
        OverthereFile fileToDelete = connection.getFile(this.artifactPath);
        if (fileToDelete.exists()) {
            ctx.logOutput("Deleting " + this.artifactPath);
            try {
                fileToDelete.delete();
            }
            finally {
                Closeables.closeQuietly((Closeable)connection);
            }
            return StepExitCode.SUCCESS;
        }
        ctx.logOutput(String.format("Nothing exist at %s, skipping deletion", this.artifactPath));
        return StepExitCode.SUCCESS;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DeleteArtifactStep)) {
            return false;
        }
        DeleteArtifactStep other = (DeleteArtifactStep)obj;
        return this.host.equals((Object)other.host) && this.artifactPath.equals(other.artifactPath);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.host.hashCode();
        result = 31 * result + this.artifactPath.hashCode();
        return result;
    }

    public Satellite getSatellite() {
        Satellite satellite = this.host.getSatellite();
        if (null == satellite) {
            satellite = this.domainHost.getSatellite();
        }
        return satellite;
    }
}

