#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

connectAndEdit()
createOrUpdateJmsModuleWithTarget(deployed.jmsModuleName, toWlsContainer(deployed.container).objectName)
createOrUpdateSubDeploymentWithTarget(deployed.jmsModuleName, deployed.subDeploymentName, deployed.container.objectName)

queuePath = '/JMSSystemResources/%s/JMSResource/%s/UniformDistributedTopics/%s' % (deployed.jmsModuleName, deployed.jmsModuleName, deployed.name)

if exists(queuePath):
    print 'Modifying UDD topic %s for target %s' % (deployed.name, deployed.container.name)
    setOrOverride = overrideWithWarning
else:
    print 'Creating UDD topic %s for target %s' % (deployed.name, deployed.container.name)
    cd('/JMSSystemResources/'+deployed.jmsModuleName+'/JMSResource/'+deployed.jmsModuleName)
    cmo.createUniformDistributedTopic(deployed.name)
    setOrOverride = set

cd(queuePath)
setOrOverride("JNDIName", deployed.jndiName)
setOrOverride("SubDeploymentName", deployed.subDeploymentName)

#set extra values in any at this level
propsToSet = deployed.getExposedProperties()
print 'propsToSet: %s' %(propsToSet)
for key, value in propsToSet.items():
    if value is not None and isinstance(value, DictionaryObject) == False:
        print 'setting %s with value %s' % (key, value)
        setOrOverride(key, value)

# create all the nested objects like DeliveryFailureParams, DeliveryParamsOverrides etc..
nestedObjects = findAllNestedObjects(deployed)
if len(nestedObjects) != 0:
    print "now setting properties %s" %(nestedObjects)
    setNestedPropertiesRecursively(deployed.name, queuePath, nestedObjects, set)

saveAndExit()
    
    


