#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

topicName = deployed.name
jmsModuleName = deployed.jmsModuleName
jmsServerName = deployed.container.name
wlsServerName = deployed.container.server.name

domainRuntime()
print "Checking state of server " + wlsServerName
cd('/ServerLifeCycleRuntimes/' + wlsServerName)
if cmo.getState() == "RUNNING":
    print "Checking whether JMS Topic " + topicName + " running on server " + wlsServerName + " contains any messages"
    topicRuntimePath='/ServerRuntimes/%s/JMSRuntime/%s.jms/JMSServers/%s/Destinations/%s!%s' %(wlsServerName, wlsServerName, jmsServerName, jmsModuleName, topicName)
    if exists(topicRuntimePath):
        print 'current directory is:'
        print pwd();
        print 'cd to %s' %(topicRuntimePath)
        cd(topicRuntimePath)
        currentNumberOfMessages = cmo.getMessagesCurrentCount()
        if (currentNumberOfMessages != 0):
            print "The topic is not empty. It contains " + str(currentNumberOfMessages) + " messages and can not be destroyed"
            sys.exit(1)


serverConfig()
connectAndEdit()
print "Destroying JMS Topic " + topicName + " in JMS Module " + jmsModuleName
cd('/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/Topics')
cmo.destroyTopic(getMBean(topicName))

saveAndExit()
