#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

queueName = deployed.name
jmsModuleName = deployed.jmsModuleName
edit()
startEdit()

subDeploymentPath = '/JMSSystemResources/' + deployed.jmsModuleName + "/SubDeployments/" + deployed.subDeploymentName
uddPath = '/JMSSystemResources/' + jmsModuleName + '/JMSResource/' + jmsModuleName + '/UniformDistributedTopics/' + deployed.name

if not exists(uddPath):
    print "UDD topic with name %s does not exist." %(deployed.name)
    sys.exit(1)

cd(subDeploymentPath)
remainingTargets = getRemainingTargets(deployed, get('Targets'))

if len(remainingTargets) != 0:
    print 'deleting target %s from the subdeployment %s' %(deployed.container.name, deployed.subDeploymentName)
    set('Targets', jarray.array(remainingTargets, ObjectName))
else:
    cd('/JMSSystemResources/' + deployed.jmsModuleName + '/JMSResource/' + deployed.jmsModuleName + '/UniformDistributedTopics')
    print 'destroying UDD topic %s' %(deployed.name)
    cmo.destroyUniformDistributedTopic(getMBean(deployed.name))

saveAndExit()
