/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

/**
 * <h2>The <a href="http://www.xebialabs.com/deployit-automated-deployment-java-applications">Deployit</a> plugin for Oracle WebLogic Server.</h2>
 * 
 * This is the standard Deployit plugin for functionality related to Oracle WebLogic
 * Server, optionally in combination with Apache web servers. It provides support 
 * for WebLogic-specific components and allows users to deploy applications containing 
 * WebLogic resources to a WebLogic Server environment.
 * 
 * <h3>Supported middleware</h3>
 * 
 * This plugin supports Oracle WebLogic Server (WLS) versions 9.x to 10.3.
 * <p>
 * Furthermore, it is possible to deploy packages that make use only of WebLogic 
 * Server-related resources to Oracle WebLogic Portal (WLP), Oracle ServiceBus (OSB) 
 * and Oracle WebLogic Integration (WLI) platforms. 
 * 
 * <h3>Requirements</h3>
 * 
 * The plugin executes its deployment and configuration tasks by connecting to the
 * target systems and executing WLST commands there. This implies that the following
 * must be possible:
 * 
 * <ul>
 * <li>creating a connection to the host on which the admin server(s) of the WLS Domain(s)
 * being administered are running, using the {@link com.xebialabs.deployit.ci.Host Host's} 
 * specified connection methods
 * <li>starting WLST on the target admin server under the user Deployit uses to connect to
 * the host (or the SUDO user, if specified)
 * </ul>
 * 
 * In addition, if the plugin is being used in an Apache/WLS environment in order to configure the
 * Apache WebLogic plugin:
 * 
 * <ul>
 * <li>the Apache server must have the correct version of the WebLogic plugin installed
 * and activated
 * <li>Apache must be configured to include all {@code *.conf} files in a certain directory
 * in its configuration
 * <li>it must be possible to create a connection from the Deployit server to the Apache
 * server(s) being administered
 * <li>the user under which Deployit connects to the Apache servers (or the SUDO user, if
 * specified) must be able to create, modify and delete files in the Apache configuration
 * directory referred to above
 * <li>this user must also be able to stop, start and restart Apache
 * </ul>
 * 
 * <h3>Components</h3>
 * 
 * WLS middleware environments are modelled on the basis of the following Configuration
 * Items (CIs):
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsDomain WLS Domain}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsCluster WLS Cluster}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsServer WLS Server} (both Managed and admin}
 * <li>Migratable Target
 * </ul>
 * 
 * Further, the plugin provides CIs for the following WLS-related resources:
 * 
 * <ul>
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsDataSource JDBC DataSource}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsMailSession Mail Sessions}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsJmsServer JMS Server} with the option to create either a backing File Store or
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsJmsModule JMS Module}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsJmsQueue JMS Queue}
 * <li>JMS Queue Template
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsJmsConnectionFactory JMS Queue Connection Factory}
 * 	   JDBC Store
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsServer Foreign JMS Server}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsDestination Foreign JMS Destination}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsForeignJmsConnectionFactory Foreign JMS Connection Factory}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsWorkManager Work Manager}
 * <li>{@link com.xebialabs.deployit.plugin.wls.ci.WlsMaximumThreadsConstraint Maximum Thread Constraint}
 * </ul>
 * 
 * Subdeployments are created automatically as a consequence of targeting JMS resources.
 * They cannot be created independently.
 * <p>
 * In environments where WLS is combined with Apache (e.g. if JEE applications running
 * in WLS are to be &quot;fronted&quot; by web servers), the plugin also supports
 * application-specific configuration of the <a href="http://download.oracle.com/docs/cd/E11035_01/wls100/plugins/apache.html">Apache WebLogic plugin</a>.
 * This is accomplished by including an {@link com.xebialabs.deployit.plugin.wls.ci.ApacheHttpdWlsPluginConfiguration}
 * CI with the relevant settings in the deployment package.
 * 
 * <h3>Supported scenarios</h3>
 * 
 * The plugin supports
 * 
 * <ul>
 * <li>the initial deployment, re- and undeployment of deployment packages to/from WLS environments
 * via the {@link com.xebialabs.deployit.plugin.wls.runbook.WlsDeploymentRunBook WLS Deployment runbook}
 * <li>the creating and deletion of Managed Servers and modification of their settings via
 * the {@link com.xebialabs.deployit.plugin.wls.runbook.WlsServerRunBook WLS Server runbook}
 * </ul>
 * 
 * For details of the exact components supported, sequence in which steps are carried out, limitations
 * etc. please consult the documentation for the appropriate runbook.
 * 
 * <h4>Mapping</h4>
 * 
 * {@link com.xebialabs.deployit.ci.artifact.Ear EARs}, {@link com.xebialabs.deployit.ci.artifact.War WARs}, {@link com.xebialabs.deployit.ci.artifact.EjbJar EJB JARs}
 * and {@link com.xebialabs.deployit.plugin.wls.ci.WlsSharedLibrary shared libraries} in a deployment package can be mapped to:
 * 
 * <ul>
 * <li>a specified domain in the target environment
 * <li>a specified cluster within the target domain
 * <li>a specified server (incl. the admin server) within the target domain
 * </ul>
 * 
 * If the target environment contains Apache web servers and the deployment 
 * package contains Apache WebLogic Plugin configuration(s), each plugin 
 * configuration may be targeted at one or web servers.
 * <p>
 * JDBC DataSources and Mail Sessions can be targeted to:
 * 
 * <ul>
 * <li>a specified cluster within the target domain
 * <li>a specified server (incl. the admin server) within the target domain
 * </ul>
 * 
 * JMS Servers can be mapped to:
 * 
 * <ul>
 * <li>a Managed Server within the target domain
 * <li>a Migratable Target within the target domain
 * </ul>
 * 
 * JMS Resources can be mapped to:
 * 
 * <ul>
 * <li>a JMS Server within the target domain
 * </ul>
 * 
 * <h3>Known limitations</h3>
 * 
 * The plugin does not currently support
 * 
 * <ul>
 * <li>installation, maintenance or removal of Oracle WebLogic Server itself
 * <li>modification or deletion of domains
 * <li>creation, modification or deletion of clusters
 * </ul>
 * 
 * If you have questions, comments or feedback please <a href="mailto:deployit-dev@xebialabs.com">contact</a>
 * the WebLogic development team at XebiaLabs.
 * 
 * @version 1.2
 */
package com.xebialabs.deployit.plugin.wls;